/// <reference path="./internal_*.d.ts" />
declare namespace Internal {
    class EjectorBlock extends Internal.HorizontalKineticBlock implements Internal.ProperWaterloggedBlock, Internal.CustomFrictionBlock, Internal.IBE<Internal.EjectorBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getFriction(state: Internal.BlockState_, world: Internal.LevelReader_, pos: BlockPos_, entity: Internal.Entity_): number;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.EjectorBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getBlockEntityType(): Internal.BlockEntityType<Internal.EjectorBlockEntity>;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.EjectorBlockEntity;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        arch$registryName(): ResourceLocation;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getBlockEntityClass(): typeof Internal.EjectorBlockEntity;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.EjectorBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.EjectorBlockEntity>;
        showCapacityWithAnnotation(): boolean;
        emi(amount: number): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.EjectorBlockEntity>
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
        get blockEntityClass(): typeof Internal.EjectorBlockEntity
    }
    type EjectorBlock_ = EjectorBlock;
    interface IMaterialAdaptingBuffer {
        abstract getMaterial(): Internal.BlockState;
        get material(): Internal.BlockState
        (): Internal.BlockState_;
    }
    type IMaterialAdaptingBuffer_ = IMaterialAdaptingBuffer;
    interface HierarchyBoundsListener extends Internal.EventListener {
        abstract ancestorResized(arg0: Internal.HierarchyEvent_): void;
        abstract ancestorMoved(arg0: Internal.HierarchyEvent_): void;
    }
    type HierarchyBoundsListener_ = HierarchyBoundsListener;
    interface ValueLayout$OfDouble extends Internal.ValueLayout {
        sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract toString(): string;
        withName(arg0: string): Internal.MemoryLayout;
        abstract arrayElementVarHandle(...arg0: number[]): Internal.VarHandle;
        sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract name(): Internal.Optional<string>;
        byteOffset(...arg0: any_[]): number;
        abstract byteSize(): number;
        withByteAlignment(arg0: number): Internal.MemoryLayout;
        withOrder(arg0: Internal.ByteOrder_): Internal.ValueLayout;
        structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        withoutName(): Internal.MemoryLayout;
        abstract hashCode(): number;
        abstract order(): Internal.ByteOrder;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        abstract byteAlignment(): number;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        abstract carrier(): typeof any;
        unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
        abstract equals(arg0: any): boolean;
    }
    type ValueLayout$OfDouble_ = ValueLayout$OfDouble;
    interface ETFVertexConsumer {
        abstract etf$initETFVertexConsumer(arg0: Internal.MultiBufferSource_, arg1: Internal.RenderType_): void;
        abstract etf$getProvider(): Internal.MultiBufferSource;
        abstract etf$getETFTexture(): Internal.ETFTexture;
        abstract etf$getRenderLayer(): Internal.RenderType;
    }
    type ETFVertexConsumer_ = ETFVertexConsumer;
    interface IntSupplier {
        abstract getAsInt(): number;
        get asInt(): number
        (): number;
    }
    type IntSupplier_ = IntSupplier;
    abstract class AbstractChassisBlock extends Internal.RotatedPillarBlock implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.ChassisBlockEntity>, Internal.TransformableBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.ChassisBlockEntity>): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        transform(state: Internal.BlockState_, transform: Internal.StructureTransform_): Internal.BlockState;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.ChassisBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.ChassisBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.ChassisBlockEntity;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityClass(): typeof Internal.ChassisBlockEntity;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getBlockEntityType(): Internal.BlockEntityType<Internal.ChassisBlockEntity>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        abstract getGlueableSide(arg0: Internal.BlockState_, arg1: Internal.Direction_): Internal.BooleanProperty;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.ChassisBlockEntity
        get blockEntityType(): Internal.BlockEntityType<Internal.ChassisBlockEntity>
    }
    type AbstractChassisBlock_ = AbstractChassisBlock;
    class ItemDragonEgg extends Internal.Item {
        constructor(type: Internal.DragonColor_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        readonly type: Internal.DragonColor;
        static readonly EGGS: {[key: Internal.DragonColor]: Internal.ItemDragonEgg, [key: Internal.DragonColor]: Internal.ItemDragonEgg, [key: Internal.DragonColor]: Internal.ItemDragonEgg, [key: Internal.DragonColor]: Internal.ItemDragonEgg, [key: Internal.DragonColor]: Internal.ItemDragonEgg, [key: Internal.DragonColor]: Internal.ItemDragonEgg, [key: Internal.DragonColor]: Internal.ItemDragonEgg, [key: Internal.DragonColor]: Internal.ItemDragonEgg, [key: Internal.DragonColor]: Internal.ItemDragonEgg, [key: Internal.DragonColor]: Internal.ItemDragonEgg, [key: Internal.DragonColor]: Internal.ItemDragonEgg, [key: Internal.DragonColor]: Internal.ItemDragonEgg};
    }
    type ItemDragonEgg_ = ItemDragonEgg;
    interface DimensionSpecialEffectsExtensions {
        renderClouds(level: Internal.ClientLevel_, ticks: number, partialTick: number, poseStack: Internal.PoseStack_, camX: number, camY: number, camZ: number, projectionMatrix: Matrix4f_): boolean;
        renderSnowAndRain(level: Internal.ClientLevel_, ticks: number, partialTick: number, lightTexture: Internal.LightTexture_, camX: number, camY: number, camZ: number): boolean;
        tickRain(level: Internal.ClientLevel_, ticks: number, camera: Internal.Camera_): boolean;
        renderSky(level: Internal.ClientLevel_, ticks: number, partialTick: number, poseStack: Internal.PoseStack_, camera: Internal.Camera_, projectionMatrix: Matrix4f_, isFoggy: boolean, setupFog: Internal.Runnable_): boolean;
        adjustLightmapColors(level: Internal.ClientLevel_, partialTicks: number, skyDarken: number, skyLight: number, blockLight: number, pixelX: number, pixelY: number, colors: Vec3f_): void;
    }
    type DimensionSpecialEffectsExtensions_ = DimensionSpecialEffectsExtensions;
    class LapisFluidPipeBlock extends jagm.classicpipes.block.FluidPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
        static readonly FACING: Internal.EnumProperty<Internal.FacingOrNone>;
    }
    type LapisFluidPipeBlock_ = LapisFluidPipeBlock;
    class TurtleUpgradeType extends Internal.Enum<Internal.TurtleUpgradeType> {
        isPeripheral(): boolean;
        static values(): Internal.TurtleUpgradeType[];
        static valueOf(name: string): Internal.TurtleUpgradeType;
        isTool(): boolean;
        get peripheral(): boolean
        get tool(): boolean
        static readonly TOOL: Internal.TurtleUpgradeType;
        static readonly PERIPHERAL: Internal.TurtleUpgradeType;
        static readonly BOTH: Internal.TurtleUpgradeType;
    }
    type TurtleUpgradeType_ = "both" | "tool" | TurtleUpgradeType | "peripheral";
    class TrackMaterial$TrackModelHolder extends Internal.Record {
        constructor(tie: Internal.PartialModel_, leftSegment: Internal.PartialModel_, rightSegment: Internal.PartialModel_)
        tie(): Internal.PartialModel;
        leftSegment(): Internal.PartialModel;
        rightSegment(): Internal.PartialModel;
    }
    type TrackMaterial$TrackModelHolder_ = TrackMaterial$TrackModelHolder;
    interface RecipeSerializer <T extends Internal.Recipe<any>> {
        register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        abstract fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): T;
        abstract fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): T;
        abstract toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: T): void;
        readonly MAP_EXTENDING: Internal.RecipeSerializer<Internal.MapExtendingRecipe>;
        readonly ARMOR_DYE: Internal.RecipeSerializer<Internal.ArmorDyeRecipe>;
        readonly TIPPED_ARROW: Internal.RecipeSerializer<Internal.TippedArrowRecipe>;
        readonly SMELTING_RECIPE: Internal.RecipeSerializer<Internal.SmeltingRecipe>;
        readonly SUSPICIOUS_STEW: Internal.RecipeSerializer<Internal.SuspiciousStewRecipe>;
        readonly FIREWORK_STAR: Internal.RecipeSerializer<Internal.FireworkStarRecipe>;
        readonly SHAPELESS_RECIPE: Internal.ShapelessRecipe$Serializer;
        readonly BOOK_CLONING: Internal.RecipeSerializer<Internal.BookCloningRecipe>;
        readonly SHULKER_BOX_COLORING: Internal.RecipeSerializer<Internal.ShulkerBoxColoring>;
        readonly STONECUTTER: Internal.RecipeSerializer<Internal.StonecutterRecipe>;
        readonly FIREWORK_ROCKET: Internal.RecipeSerializer<Internal.FireworkRocketRecipe>;
        readonly FIREWORK_STAR_FADE: Internal.RecipeSerializer<Internal.FireworkStarFadeRecipe>;
        readonly SMITHING_TRANSFORM: Internal.SmithingTransformRecipe$Serializer;
        readonly MAP_CLONING: Internal.RecipeSerializer<Internal.MapCloningRecipe>;
        readonly DECORATED_POT_RECIPE: Internal.RecipeSerializer<Internal.DecoratedPotRecipe>;
        readonly SMITHING_TRIM: Internal.SmithingTrimRecipe$Serializer;
        readonly BLASTING_RECIPE: Internal.RecipeSerializer<Internal.BlastingRecipe>;
        readonly SMOKING_RECIPE: Internal.RecipeSerializer<Internal.SmokingRecipe>;
        readonly BANNER_DUPLICATE: Internal.RecipeSerializer<Internal.BannerDuplicateRecipe>;
        readonly SHIELD_DECORATION: Internal.RecipeSerializer<Internal.ShieldDecorationRecipe>;
        readonly REPAIR_ITEM: Internal.RecipeSerializer<Internal.RepairItemRecipe>;
        readonly CAMPFIRE_COOKING_RECIPE: Internal.RecipeSerializer<Internal.CampfireCookingRecipe>;
        readonly SHAPED_RECIPE: Internal.ShapedRecipe$Serializer;
    }
    type RecipeSerializer_<T extends Internal.Recipe<any>> = Special.RecipeSerializer | RecipeSerializer<T>;
    interface BlockApiLookup$BlockEntityApiProvider <A, C> {
        abstract find(arg0: Internal.BlockEntity_, arg1: C): A;
        (arg0: Internal.BlockEntity, arg1: C): A;
    }
    type BlockApiLookup$BlockEntityApiProvider_<A, C> = BlockApiLookup$BlockEntityApiProvider<A, C>;
    class ThresholdSwitchBlockEntity$ThresholdType extends Internal.Enum<Internal.ThresholdSwitchBlockEntity$ThresholdType> {
        static values(): Internal.ThresholdSwitchBlockEntity$ThresholdType[];
        static valueOf(name: string): Internal.ThresholdSwitchBlockEntity$ThresholdType;
        static readonly FLUID: Internal.ThresholdSwitchBlockEntity$ThresholdType;
        static readonly UNSUPPORTED: Internal.ThresholdSwitchBlockEntity$ThresholdType;
        static readonly ITEM: Internal.ThresholdSwitchBlockEntity$ThresholdType;
        static readonly CUSTOM: Internal.ThresholdSwitchBlockEntity$ThresholdType;
    }
    type ThresholdSwitchBlockEntity$ThresholdType_ = "fluid" | ThresholdSwitchBlockEntity$ThresholdType | "unsupported" | "custom" | "item";
    class LinkPinBlock extends Internal.AbstractDyeableSingleBufferBlock implements Internal.BlockStateBlockItemGroup$GroupedBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.DyeableBlockEntity>): void;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.DyeableBlockEntity;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.DyeableBlockEntity>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.DyeableBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly STYLE: Internal.EnumProperty<Internal.LinkPinBlock$Style>;
    }
    type LinkPinBlock_ = LinkPinBlock;
    abstract class FeatureSize {
        constructor($$0: Internal.OptionalInt_)
        minClippedHeight(): Internal.OptionalInt;
        abstract getSizeAtHeight(arg0: number, arg1: number): number;
        static readonly CODEC: Internal.Codec<Internal.FeatureSize>;
    }
    type FeatureSize_ = FeatureSize;
    class BlockAxis extends Internal.RotatedPillarBlock {
        constructor(p_55926_: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BlockAxis_ = BlockAxis;
    interface CellHasher {
        abstract hashCell(arg0: number, arg1: number, arg2: number): number;
        abstract hashAt(arg0: number, arg1: number, arg2: number): number;
    }
    type CellHasher_ = CellHasher;
    interface Element extends org.w3c.dom.Node {
        abstract setIdAttributeNS(arg0: string, arg1: string, arg2: boolean): void;
        abstract getFirstChild(): org.w3c.dom.Node;
        abstract removeAttributeNode(arg0: Internal.Attr_): Internal.Attr;
        abstract getElementsByTagNameNS(arg0: string, arg1: string): Internal.NodeList;
        abstract getElementsByTagName(arg0: string): Internal.NodeList;
        abstract cloneNode(arg0: boolean): org.w3c.dom.Node;
        abstract setAttributeNS(arg0: string, arg1: string, arg2: string): void;
        abstract getFeature(arg0: string, arg1: string): any;
        abstract isDefaultNamespace(arg0: string): boolean;
        abstract hasAttributes(): boolean;
        abstract isEqualNode(arg0: org.w3c.dom.Node_): boolean;
        abstract getLocalName(): string;
        abstract getTagName(): string;
        abstract getAttributeNodeNS(arg0: string, arg1: string): Internal.Attr;
        abstract getAttributeNS(arg0: string, arg1: string): string;
        abstract setAttributeNodeNS(arg0: Internal.Attr_): Internal.Attr;
        abstract setPrefix(arg0: string): void;
        abstract removeAttributeNS(arg0: string, arg1: string): void;
        abstract hasAttribute(arg0: string): boolean;
        abstract getChildNodes(): Internal.NodeList;
        abstract getSchemaTypeInfo(): Internal.TypeInfo;
        abstract lookupNamespaceURI(arg0: string): string;
        abstract setNodeValue(arg0: string): void;
        abstract getAttributeNode(arg0: string): Internal.Attr;
        abstract setUserData(arg0: string, arg1: any, arg2: Internal.UserDataHandler_): any;
        abstract getBaseURI(): string;
        abstract getUserData(arg0: string): any;
        abstract getParentNode(): org.w3c.dom.Node;
        abstract setIdAttributeNode(arg0: Internal.Attr_, arg1: boolean): void;
        abstract getPrefix(): string;
        abstract getLastChild(): org.w3c.dom.Node;
        abstract compareDocumentPosition(arg0: org.w3c.dom.Node_): number;
        abstract normalize(): void;
        abstract getOwnerDocument(): Internal.Document;
        abstract hasChildNodes(): boolean;
        abstract getNodeName(): string;
        abstract setTextContent(arg0: string): void;
        abstract removeChild(arg0: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract getNodeValue(): string;
        abstract appendChild(arg0: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract setAttributeNode(arg0: Internal.Attr_): Internal.Attr;
        abstract getNamespaceURI(): string;
        abstract insertBefore(arg0: org.w3c.dom.Node_, arg1: org.w3c.dom.Node_): org.w3c.dom.Node;
        abstract isSupported(arg0: string, arg1: string): boolean;
        abstract getPreviousSibling(): org.w3c.dom.Node;
        abstract lookupPrefix(arg0: string): string;
        abstract isSameNode(arg0: org.w3c.dom.Node_): boolean;
        abstract getAttribute(arg0: string): string;
        abstract setAttribute(arg0: string, arg1: string): void;
        abstract getTextContent(): string;
        abstract getAttributes(): Internal.NamedNodeMap;
        abstract getNodeType(): number;
        abstract getNextSibling(): org.w3c.dom.Node;
        abstract setIdAttribute(arg0: string, arg1: boolean): void;
        abstract removeAttribute(arg0: string): void;
        abstract hasAttributeNS(arg0: string, arg1: string): boolean;
        abstract replaceChild(arg0: org.w3c.dom.Node_, arg1: org.w3c.dom.Node_): org.w3c.dom.Node;
        get firstChild(): org.w3c.dom.Node
        get localName(): string
        get tagName(): string
        set attributeNodeNS(arg0: Internal.Attr_)
        set prefix(arg0: string)
        get childNodes(): Internal.NodeList
        get schemaTypeInfo(): Internal.TypeInfo
        set nodeValue(arg0: string)
        get baseURI(): string
        get parentNode(): org.w3c.dom.Node
        get prefix(): string
        get lastChild(): org.w3c.dom.Node
        get ownerDocument(): Internal.Document
        get nodeName(): string
        set textContent(arg0: string)
        get nodeValue(): string
        set attributeNode(arg0: Internal.Attr_)
        get namespaceURI(): string
        get previousSibling(): org.w3c.dom.Node
        get textContent(): string
        get attributes(): Internal.NamedNodeMap
        get nodeType(): number
        get nextSibling(): org.w3c.dom.Node
    }
    type Element_ = Element;
    interface TrinketPlayerScreenHandler {
        abstract trinkets$getTrinketSlotEnd(): number;
        abstract trinkets$getSlotTypes(arg0: Internal.SlotGroup_): Internal.List<dev.emi.trinkets.api.SlotType>;
        abstract trinkets$getGroupCount(): number;
        abstract trinkets$getSlotHeights(arg0: Internal.SlotGroup_): Internal.List<dev.emi.trinkets.Point>;
        abstract trinkets$getGroupPos(arg0: Internal.SlotGroup_): dev.emi.trinkets.Point;
        abstract trinkets$getSlotHeight(arg0: Internal.SlotGroup_, arg1: number): dev.emi.trinkets.Point;
        abstract trinkets$getTrinketSlotStart(): number;
        abstract trinkets$getGroupNum(arg0: Internal.SlotGroup_): number;
        abstract trinkets$getSlotWidth(arg0: Internal.SlotGroup_): number;
        abstract trinkets$updateTrinketSlots(arg0: boolean): void;
    }
    type TrinketPlayerScreenHandler_ = TrinketPlayerScreenHandler;
    interface SpriteContentsAccessor {
        abstract getAnimatedTexture(): Internal.SpriteContents$AnimatedTexture;
        get animatedTexture(): Internal.SpriteContents$AnimatedTexture
        (): Internal.SpriteContents$AnimatedTexture_;
    }
    type SpriteContentsAccessor_ = SpriteContentsAccessor;
    interface PlayerRideable {
    }
    type PlayerRideable_ = PlayerRideable;
    class ItemStack$TooltipPart extends Internal.Enum<Internal.ItemStack$TooltipPart> {
        static values(): Internal.ItemStack$TooltipPart[];
        getMask(): number;
        static valueOf($$0: string): Internal.ItemStack$TooltipPart;
        get mask(): number
        static readonly ENCHANTMENTS: Internal.ItemStack$TooltipPart;
        static readonly CAN_PLACE: Internal.ItemStack$TooltipPart;
        static readonly UPGRADES: Internal.ItemStack$TooltipPart;
        static readonly CAN_DESTROY: Internal.ItemStack$TooltipPart;
        static readonly DYE: Internal.ItemStack$TooltipPart;
        static readonly MODIFIERS: Internal.ItemStack$TooltipPart;
        static readonly ADDITIONAL: Internal.ItemStack$TooltipPart;
        static readonly UNBREAKABLE: Internal.ItemStack$TooltipPart;
    }
    type ItemStack$TooltipPart_ = "modifiers" | "upgrades" | "enchantments" | "unbreakable" | "can_place" | "dye" | "can_destroy" | ItemStack$TooltipPart | "additional";
    class NarratableEntry$NarrationPriority extends Internal.Enum<Internal.NarratableEntry$NarrationPriority> {
        static values(): Internal.NarratableEntry$NarrationPriority[];
        static valueOf($$0: string): Internal.NarratableEntry$NarrationPriority;
        isTerminal(): boolean;
        get terminal(): boolean
        static readonly NONE: Internal.NarratableEntry$NarrationPriority;
        static readonly HOVERED: Internal.NarratableEntry$NarrationPriority;
        static readonly FOCUSED: Internal.NarratableEntry$NarrationPriority;
    }
    type NarratableEntry$NarrationPriority_ = "focused" | "hovered" | NarratableEntry$NarrationPriority | "none";
    class EndGatewayBlock extends Internal.BaseEntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type EndGatewayBlock_ = EndGatewayBlock;
    interface IStrictSignalTrain {
        abstract railways$setStrictSignals(arg0: boolean): void;
        (arg0: boolean): void;
    }
    type IStrictSignalTrain_ = IStrictSignalTrain;
    interface AccessorMobEffectInstance {
        abstract bookshelf$getHiddenEffect(): Internal.MobEffectInstance;
        abstract bookshelf$setHiddenEffect(arg0: Internal.MobEffectInstance_): void;
        abstract setDuration(arg0: number): void;
        abstract bookshelf$tickDownDuration(): number;
        set duration(arg0: number)
    }
    type AccessorMobEffectInstance_ = AccessorMobEffectInstance;
    interface StructurePieceType$ContextlessType extends Internal.StructurePieceType {
        abstract load(arg0: Internal.CompoundTag_): Internal.StructurePiece;
        setPieceId($$0: Internal.StructurePieceType$ContextlessType_, $$1: string): Internal.StructurePieceType;
        load($$0: Internal.StructurePieceSerializationContext_, $$1: Internal.CompoundTag_): Internal.StructurePiece;
        (arg0: Internal.CompoundTag): Internal.StructurePiece_;
    }
    type StructurePieceType$ContextlessType_ = StructurePieceType$ContextlessType;
    class BlockEntry <T extends Internal.Block> extends Internal.ItemProviderEntry<T> {
        constructor(owner: Internal.AbstractRegistrate_<any>, delegate: Internal.RegistryObject_<T>)
        static cast<T extends Internal.Block>(entry: Internal.RegistryEntry_<T>): Internal.BlockEntry<T>;
        emi(amount: number): Internal.EmiStack;
        getDefaultState(): Internal.BlockState;
        static of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): Internal.NonNullSupplier<T>;
        lazy(): Internal.NonNullSupplier<T>;
        static of<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        emi(): Internal.EmiStack;
        has(state: Internal.BlockState_): boolean;
        static lazy<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        get defaultState(): Internal.BlockState
    }
    type BlockEntry_<T extends Internal.Block> = BlockEntry<T>;
    class InputConstants$Key implements Internal.KeyAccess, Internal.AccessInputConstantsKey {
        getDisplayName(): net.minecraft.network.chat.Component;
        static getNAME_MAP$controlling_$md$fca01f$0(): Internal.Map<any, any>;
        getName(): string;
        static controlling$getNAME_MAP(): Internal.Map<string, Internal.InputConstants$Key>;
        getType(): Internal.InputConstants$Type;
        getValue(): number;
        setDisplayName(arg0: Internal.LazyLoadedValue_<any>): void;
        getNumericKeyValue(): Internal.OptionalInt;
        get displayName(): net.minecraft.network.chat.Component
        get NAME_MAP$controlling_$md$fca01f$0(): Internal.Map<any, any>
        get name(): string
        get type(): Internal.InputConstants$Type
        get value(): number
        set displayName(arg0: Internal.LazyLoadedValue_<any>)
        get numericKeyValue(): Internal.OptionalInt
    }
    type InputConstants$Key_ = InputConstants$Key;
    class CactusBlock extends Internal.Block implements Internal.IPlantable {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        getPlant(world: Internal.BlockGetter_, pos: BlockPos_): Internal.BlockState;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly AGE: Internal.IntegerProperty;
        static readonly MAX_AGE: 15;
    }
    type CactusBlock_ = CactusBlock;
    class ClientboundCustomChatCompletionsPacket extends Internal.Record implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.ClientboundCustomChatCompletionsPacket$Action_, $$1: Internal.List_<string>)
        handle(arg0: Internal.PacketListener_): void;
        entries(): Internal.List<string>;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        action(): Internal.ClientboundCustomChatCompletionsPacket$Action;
        get skippable(): boolean
    }
    type ClientboundCustomChatCompletionsPacket_ = ClientboundCustomChatCompletionsPacket;
    class ArgumentSignatures$Entry extends Internal.Record {
        constructor($$0: string, $$1: Internal.MessageSignature_)
        constructor($$0: Internal.FriendlyByteBuf_)
        name(): string;
        signature(): Internal.MessageSignature;
        write($$0: Internal.FriendlyByteBuf_): void;
    }
    type ArgumentSignatures$Entry_ = ArgumentSignatures$Entry;
    class ItemThoughtKnot extends Internal.Item implements Internal.IotaHolderItem {
        constructor(properties: Internal.Item$Properties_)
        canWrite(stack: Internal.ItemStack_, iota: Internal.Iota_): boolean;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        writeable(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getColor(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        readIotaTag(stack: Internal.ItemStack_): Internal.CompoundTag;
        static appendHoverText(self: Internal.IotaHolderItem_, stack: Internal.ItemStack_, components: Internal.List_<net.minecraft.network.chat.Component>, flag: Internal.TooltipFlag_): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        writeDatum(stack: Internal.ItemStack_, iota: Internal.Iota_): void;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        readIota(stack: Internal.ItemStack_, world: Internal.ServerLevel_): Internal.Iota;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emptyIota(stack: Internal.ItemStack_): Internal.Iota;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TAG_DATA: "data";
        static readonly WRITTEN_PRED: ResourceLocation;
    }
    type ItemThoughtKnot_ = ItemThoughtKnot;
    class PartBuilderToolRecycle implements Internal.IPartBuilderRecipe {
        constructor(id: ResourceLocation_, pattern: Internal.Ingredient_)
        constructor(id: ResourceLocation_, toolRequirement: Internal.SizedIngredient_, pattern: Internal.Ingredient_)
        getItemsUsed(inv: Internal.IPartBuilderContainer_): number;
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        getPatterns(inv: Internal.IPartBuilderContainer_): Internal.Stream<slimeknights.tconstruct.library.recipe.partbuilder.Pattern>;
        /**
         * @deprecated
        */
        getLeftover(inventoryWrapper: Internal.PartBuilderContainerWrapper_): Internal.ItemStack;
        partialMatch(inv: Internal.IPartBuilderContainer_): boolean;
        getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        getCost(): number;
        getLeftover(inv: Internal.PartBuilderContainerWrapper_, pattern: slimeknights.tconstruct.library.recipe.partbuilder.Pattern_): Internal.ItemStack;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        matches(inv: Internal.IPartBuilderContainer_, pLevel: Internal.Level_): boolean;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        getPattern(): slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        assemble(inv: Internal.IPartBuilderContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        assemble(inv: Internal.IPartBuilderContainer_, pattern: slimeknights.tconstruct.library.recipe.partbuilder.Pattern_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getRemainingItems($$0: Internal.IPartBuilderContainer_): Internal.NonNullList<Internal.ItemStack>;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        getTitle(): net.minecraft.network.chat.Component;
        getText(inv: Internal.IPartBuilderContainer_): Internal.List<net.minecraft.network.chat.Component>;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get cost(): number
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get pattern(): slimeknights.tconstruct.library.recipe.partbuilder.Pattern
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get title(): net.minecraft.network.chat.Component
    }
    type PartBuilderToolRecycle_ = PartBuilderToolRecycle;
    abstract class VarItem <V extends Internal.Enum<V> & Internal.IVariant<V>, I extends Internal.VarItem<V, I>> extends owmii.powah.lib.item.ItemBase implements Internal.IVariantEntry<V, I> {
        constructor(properties: Internal.Item$Properties_)
        constructor(properties: Internal.Item$Properties_, variant: V)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        oneTimeInfo(player: Internal.Player_, stack: Internal.ItemStack_, component: net.minecraft.network.chat.Component_): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getVariant(): Internal.IVariant<any>;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getItemModelType(): Internal.ItemModelType;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get variant(): Internal.IVariant<any>
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get itemModelType(): Internal.ItemModelType
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type VarItem_<V extends Internal.Enum<V> & Internal.IVariant<V>, I extends Internal.VarItem<V, I>> = VarItem<V, I>;
    class PainterObjectStorage {
        constructor(p: Internal.Painter_)
        createScreenObjects(): any[];
        getObject(key: string): Internal.PainterObject;
        clear(): void;
        getObjects(): Internal.Collection<Internal.PainterObject>;
        remove(id: string): void;
        handle(root: Internal.CompoundTag_): void;
        get objects(): Internal.Collection<Internal.PainterObject>
        readonly painter: Internal.Painter;
    }
    type PainterObjectStorage_ = PainterObjectStorage;
    abstract class MinecraftServer extends Internal.ReentrantBlockableEventLoop<Internal.TickTask> implements Internal.MinecraftServerKJS, Internal.CommandSource, Internal.MinecraftServerAccessor, Internal.ITimeTrackingServer, Internal.AutoCloseable {
        constructor($$0: Internal.Thread_, $$1: Internal.LevelStorageSource$LevelStorageAccess_, $$2: Internal.PackRepository_, $$3: Internal.WorldStem_, $$4: Internal.Proxy_, $$5: Internal.DataFixer_, $$6: Internal.Services_, $$7: any_)
        getConnection(): Internal.ServerConnectionListener;
        mfix$getLastTickStartTime(): number;
        self(): this;
        getCompressionThreshold(): number;
        getPlayerIdleTimeout(): number;
        abstract fillServerSystemReport(arg0: Internal.SystemReport_): Internal.SystemReport;
        isTimeProfilerRunning(): boolean;
        getProxy(): Internal.Proxy;
        getResourceManager(): Internal.ResourceManager;
        setDefaultGameType($$0: Internal.GameType_): void;
        getAdvancement(id: ResourceLocation_): Internal.AdvancementJS;
        saveEverything($$0: boolean, $$1: boolean, $$2: boolean): boolean;
        onServerCrash($$0: Internal.CrashReport_): void;
        registries(): Internal.LayeredRegistryAccess<Internal.RegistryLayer>;
        askEither<Source>($$0: Internal.Function_<Internal.ProcessorHandle<Internal.Either<Source, Internal.Exception>>, Internal.TickTask>): Internal.CompletableFuture<Source>;
        usesAuthentication(): boolean;
        setEnforceWhitelist($$0: boolean): void;
        getFunctions(): Internal.ServerFunctionManager;
        port_lib$getStorageSource(): Internal.LevelStorageSource$LevelStorageAccess;
        scheduleInTicks(ticks: number, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        isShutdown(): boolean;
        getScaledTrackingDistance($$0: number): number;
        runCommandSilent(command: string): number;
        scheduleRepeatingInTicks(ticks: number, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        publishServer($$0: Internal.GameType_, $$1: boolean, $$2: number): boolean;
        getFrameTimer(): Internal.FrameTimer;
        hasGui(): boolean;
        stopTimeProfiler(): Internal.ProfileResults;
        getDefaultGameType(): Internal.GameType;
        setDemo($$0: boolean): void;
        alwaysAccepts(): boolean;
        getTickCount(): number;
        dumpServerProperties($$0: Internal.Path_): void;
        isUnderSpawnProtection($$0: Internal.ServerLevel_, $$1: BlockPos_, $$2: Internal.Player_): boolean;
        abstract isDedicated(): boolean;
        getPackRepository(): Internal.PackRepository;
        logChatMessage($$0: net.minecraft.network.chat.Component_, $$1: Internal.ChatType$Bound_, $$2: string): void;
        getPlayerList(): Internal.PlayerList;
        getWorldPath($$0: Internal.LevelResource_): Internal.Path;
        getDisplayName(): net.minecraft.network.chat.Component;
        cancelRecordingMetrics(): void;
        finishRecordingMetrics(): void;
        getLevel($$0: Internal.ResourceKey_<Internal.Level>): Internal.ServerLevel;
        getPlayer(selector: Internal.PlayerSelector_): Internal.ServerPlayer;
        isSingleplayer(): boolean;
        setPreventProxyConnections($$0: boolean): void;
        getChatDecorator(): Internal.ChatDecorator;
        getPort(): number;
        ask<Source>($$0: Internal.Function_<Internal.ProcessorHandle<Source>, Internal.TickTask>): Internal.CompletableFuture<Source>;
        getGameRules(): Internal.GameRules;
        getCommands(): Internal.Commands;
        tickChildren($$0: Internal.BooleanSupplier_): void;
        isRecordingMetrics(): boolean;
        isSpawningAnimals(): boolean;
        getServerDirectory(): Internal.File;
        setUsesAuthentication($$0: boolean): void;
        getAllLevels(): Internal.Iterable<Internal.ServerLevel>;
        getPersistentData(): Internal.CompoundTag;
        isStopped(): boolean;
        setPlayerList($$0: Internal.PlayerList_): void;
        setLocalIp($$0: string): void;
        sendData(channel: string): void;
        getScheduledEvents(): Internal.ScheduledEvents;
        createGameModeForPlayer($$0: Internal.ServerPlayer_): Internal.ServerPlayerGameMode;
        isNetherEnabled(): boolean;
        getCustomBossEvents(): Internal.CustomBossEvents;
        getLocalIp(): string;
        isEnforceWhitelist(): boolean;
        reloadResources($$0: Internal.Collection_<string>): Internal.CompletableFuture<void>;
        saveAllChunks($$0: boolean, $$1: boolean, $$2: boolean): boolean;
        isCurrentlySaving(): boolean;
        areNpcsEnabled(): boolean;
        hidesOnlinePlayers(): boolean;
        getProfileRepository(): Internal.GameProfileRepository;
        getProfileCache(): Internal.GameProfileCache;
        getAbsoluteMaxWorldSize(): number;
        getCommandStorage(): Internal.CommandStorage;
        getForcedGameType(): Internal.GameType;
        sendSystemMessage($$0: net.minecraft.network.chat.Component_): void;
        setDifficulty($$0: Internal.Difficulty_, $$1: boolean): void;
        acceptsSuccess(): boolean;
        invalidateStatus(): void;
        overworld(): Internal.ServerLevel;
        getLevel(dimension: ResourceLocation_): Internal.ServerLevel;
        getStatus(): Internal.ServerStatus;
        static spin<S extends Internal.MinecraftServer>($$0: Internal.Function_<Internal.Thread, S>): S;
        setPlayerIdleTimeout($$0: number): void;
        getScoreboard(): Internal.ServerScoreboard;
        tickServer($$0: Internal.BooleanSupplier_): void;
        handler$zkg000$ae2$injectSpatialLevel(chunkProgressListener: Internal.ChunkProgressListener_, ci: Internal.CallbackInfo_): void;
        addTickable($$0: Internal.Runnable_): void;
        method_3777(): Internal.Thread;
        enforceSecureProfile(): boolean;
        createCommandSourceStack(): Internal.CommandSourceStack;
        schedule(timer: Internal.TemporalAmount_, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        setFlightAllowed($$0: boolean): void;
        static configurePackRepository($$0: Internal.PackRepository_, $$1: Internal.DataPackConfig_, $$2: boolean, $$3: Internal.FeatureFlagSet_): Internal.WorldDataConfiguration;
        getServerModName(): string;
        acceptsFailure(): boolean;
        abstract isCommandBlockEnabled(): boolean;
        method_16211(arg0: Internal.Runnable_): Internal.Runnable;
        getNextTickTime(): number;
        isHardcore(): boolean;
        getFile($$0: string): Internal.File;
        getSpawnRadius($$0: Internal.ServerLevel_): number;
        abstract isPublished(): boolean;
        repliesToStatus(): boolean;
        stopRecordingMetrics(): void;
        startTimeProfiler(): void;
        getPlayerCount(): number;
        getAdvancements(): Internal.ServerAdvancementManager;
        getOverworld(): Internal.ServerLevel;
        getMaxChainedNeighborUpdates(): number;
        forceTimeSynchronization(): void;
        getMotd(): string;
        isRunning(): boolean;
        getName(): net.minecraft.network.chat.Component;
        getSessionService(): Internal.MinecraftSessionService;
        abstract getRateLimitPacketsPerSecond(): number;
        abstract getOperatorUserPermissionLevel(): number;
        sendData(channel: string, data: Internal.CompoundTag_): void;
        getSingleplayerProfile(): Internal.GameProfile;
        getServerResourcePack(): Internal.Optional<Internal.MinecraftServer$ServerResourcePackInfo>;
        fillSystemReport($$0: Internal.SystemReport_): Internal.SystemReport;
        isReady(): boolean;
        setPort($$0: number): void;
        registryAccess(): Internal.RegistryAccess$Frozen;
        abstract shouldInformAdmins(): boolean;
        setDifficultyLocked($$0: boolean): void;
        stop(): void;
        localvar$ebd000$kubejs$wrapResourceManager(original: Internal.CloseableResourceManager_): Internal.CloseableResourceManager;
        getMaxPlayers(): number;
        isSpawningMonsters(): boolean;
        setPvpAllowed($$0: boolean): void;
        getKeyPair(): Internal.KeyPair;
        forceSynchronousWrites(): boolean;
        isPvpAllowed(): boolean;
        abstract getFunctionCompilationLevel(): number;
        isResourcePackRequired(): boolean;
        getServerVersion(): string;
        getProfiler(): Internal.ProfilerFiller;
        getAverageTickTime(): number;
        abstract isSingleplayerOwner(arg0: Internal.GameProfile_): boolean;
        scheduleRepeating(timer: Internal.TemporalAmount_, callback: Internal.ScheduledEvents$Callback_): Internal.ScheduledEvents$ScheduledEvent;
        setSingleplayerProfile($$0: Internal.GameProfile_): void;
        static of<Msg>($$0: string, $$1: Internal.Consumer_<Msg>): Internal.ProcessorHandle<Msg>;
        port_lib$getServerResources(): Internal.MinecraftServer$ReloadableResources;
        onServerExit(): void;
        kickUnlistedPlayers($$0: Internal.CommandSourceStack_): void;
        createTextFilterForPlayer($$0: Internal.ServerPlayer_): Internal.TextFilter;
        isDemo(): boolean;
        startRecordingMetrics($$0: Internal.Consumer_<Internal.ProfileResults>, $$1: Internal.Consumer_<Internal.Path>): void;
        getReloadableResources(): Internal.MinecraftServer$ReloadableResources;
        getProfilePermissions($$0: Internal.GameProfile_): number;
        getData(): Internal.AttachedData<any>;
        getWorldScreenshotFile(): Internal.Optional<Internal.Path>;
        getStructureManager(): Internal.StructureTemplateManager;
        getLootData(): Internal.LootDataManager;
        halt($$0: boolean): void;
        getEntities(): Internal.EntityArrayList;
        abstract isEpollEnabled(): boolean;
        method_18856(arg0: Internal.Runnable_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        abstract shouldRconBroadcast(): boolean;
        levelKeys(): Internal.Set<Internal.ResourceKey<Internal.Level>>;
        getSpawnProtectionRadius(): number;
        getProfileKeySignatureValidator(): Internal.SignatureValidator;
        getModdedStatus(): Internal.ModCheck;
        getPlayerNames(): string[];
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getRecipeManager(): Internal.RecipeManager;
        getPlayers(): Internal.EntityArrayList;
        getFixerUpper(): Internal.DataFixer;
        restoreInventories(): Internal.Map<any, any>;
        getWorldData(): Internal.WorldData;
        setMotd($$0: string): void;
        getPreventProxyConnections(): boolean;
        runCommand(command: string): number;
        isFlightAllowed(): boolean;
        get connection(): Internal.ServerConnectionListener
        get compressionThreshold(): number
        get playerIdleTimeout(): number
        get timeProfilerRunning(): boolean
        get proxy(): Internal.Proxy
        get resourceManager(): Internal.ResourceManager
        set defaultGameType($$0: Internal.GameType_)
        set enforceWhitelist($$0: boolean)
        get functions(): Internal.ServerFunctionManager
        get shutdown(): boolean
        get frameTimer(): Internal.FrameTimer
        get defaultGameType(): Internal.GameType
        set demo($$0: boolean)
        get tickCount(): number
        get dedicated(): boolean
        get packRepository(): Internal.PackRepository
        get playerList(): Internal.PlayerList
        get displayName(): net.minecraft.network.chat.Component
        get singleplayer(): boolean
        set preventProxyConnections($$0: boolean)
        get chatDecorator(): Internal.ChatDecorator
        get port(): number
        get gameRules(): Internal.GameRules
        get commands(): Internal.Commands
        get recordingMetrics(): boolean
        get spawningAnimals(): boolean
        get serverDirectory(): Internal.File
        set usesAuthentication($$0: boolean)
        get allLevels(): Internal.Iterable<Internal.ServerLevel>
        get persistentData(): Internal.CompoundTag
        get stopped(): boolean
        set playerList($$0: Internal.PlayerList_)
        set localIp($$0: string)
        get scheduledEvents(): Internal.ScheduledEvents
        get netherEnabled(): boolean
        get customBossEvents(): Internal.CustomBossEvents
        get localIp(): string
        get enforceWhitelist(): boolean
        get currentlySaving(): boolean
        get profileRepository(): Internal.GameProfileRepository
        get profileCache(): Internal.GameProfileCache
        get absoluteMaxWorldSize(): number
        get commandStorage(): Internal.CommandStorage
        get forcedGameType(): Internal.GameType
        get status(): Internal.ServerStatus
        set playerIdleTimeout($$0: number)
        get scoreboard(): Internal.ServerScoreboard
        set flightAllowed($$0: boolean)
        get serverModName(): string
        get commandBlockEnabled(): boolean
        get nextTickTime(): number
        get hardcore(): boolean
        get published(): boolean
        get playerCount(): number
        get advancements(): Internal.ServerAdvancementManager
        get overworld(): Internal.ServerLevel
        get maxChainedNeighborUpdates(): number
        get motd(): string
        get running(): boolean
        get name(): net.minecraft.network.chat.Component
        get sessionService(): Internal.MinecraftSessionService
        get rateLimitPacketsPerSecond(): number
        get operatorUserPermissionLevel(): number
        get singleplayerProfile(): Internal.GameProfile
        get serverResourcePack(): Internal.Optional<Internal.MinecraftServer$ServerResourcePackInfo>
        get ready(): boolean
        set port($$0: number)
        set difficultyLocked($$0: boolean)
        get maxPlayers(): number
        get spawningMonsters(): boolean
        set pvpAllowed($$0: boolean)
        get keyPair(): Internal.KeyPair
        get pvpAllowed(): boolean
        get functionCompilationLevel(): number
        get resourcePackRequired(): boolean
        get serverVersion(): string
        get profiler(): Internal.ProfilerFiller
        get averageTickTime(): number
        set singleplayerProfile($$0: Internal.GameProfile_)
        get demo(): boolean
        get reloadableResources(): Internal.MinecraftServer$ReloadableResources
        get data(): Internal.AttachedData<any>
        get worldScreenshotFile(): Internal.Optional<Internal.Path>
        get structureManager(): Internal.StructureTemplateManager
        get lootData(): Internal.LootDataManager
        get entities(): Internal.EntityArrayList
        get epollEnabled(): boolean
        get spawnProtectionRadius(): number
        get profileKeySignatureValidator(): Internal.SignatureValidator
        get moddedStatus(): Internal.ModCheck
        get playerNames(): string[]
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get recipeManager(): Internal.RecipeManager
        get players(): Internal.EntityArrayList
        get fixerUpper(): Internal.DataFixer
        get worldData(): Internal.WorldData
        set motd($$0: string)
        get preventProxyConnections(): boolean
        get flightAllowed(): boolean
        static readonly START_CHUNK_RADIUS: 11;
        static readonly ABSOLUTE_MAX_WORLD_SIZE: 29999984;
        static readonly DEMO_SETTINGS: Internal.LevelSettings;
        resources: Internal.MinecraftServer$ReloadableResources;
        readonly storageSource: Internal.LevelStorageSource$LevelStorageAccess;
        static readonly VANILLA_BRAND: "vanilla";
        static readonly ANONYMOUS_PLAYER_PROFILE: Internal.GameProfile;
        readonly tickTimes: number[];
        static readonly MS_PER_TICK: 50;
    }
    type MinecraftServer_ = MinecraftServer;
    interface StructurePoolElementType <P extends Internal.StructurePoolElement> {
        abstract codec(): Internal.Codec<P>;
        register<P extends Internal.StructurePoolElement>($$0: string, $$1: Internal.Codec_<P>): this;
        (): Internal.Codec_<P>;
        readonly LIST: Internal.StructurePoolElementType<Internal.ListPoolElement>;
        readonly LEGACY: Internal.StructurePoolElementType<Internal.LegacySinglePoolElement>;
        readonly FEATURE: Internal.StructurePoolElementType<Internal.FeaturePoolElement>;
        readonly EMPTY: Internal.StructurePoolElementType<Internal.EmptyPoolElement>;
        readonly SINGLE: Internal.StructurePoolElementType<Internal.SinglePoolElement>;
    }
    type StructurePoolElementType_<P extends Internal.StructurePoolElement> = Special.StructurePoolElement | StructurePoolElementType<P>;
    interface EnchantmentBuilder$PostFunction {
        abstract apply(arg0: Internal.LivingEntity_, arg1: Internal.Entity_, arg2: number): void;
        (arg0: Internal.LivingEntity, arg1: Internal.Entity, arg2: number): void;
    }
    type EnchantmentBuilder$PostFunction_ = EnchantmentBuilder$PostFunction;
    class GaugeBlock extends Internal.DirectionalAxisKineticBlock implements Internal.IBE<Internal.GaugeBlockEntity> {
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static speed(properties: Internal.BlockBehaviour$Properties_): Internal.GaugeBlock;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        shouldRenderHeadOnFace(world: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_, face: Internal.Direction_): boolean;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        getBlockEntityType(): Internal.BlockEntityType<Internal.GaugeBlockEntity>;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.GaugeBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getBlockEntityClass(): typeof Internal.GaugeBlockEntity;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.GaugeBlockEntity>): void;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.GaugeBlockEntity;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        static stress(properties: Internal.BlockBehaviour$Properties_): Internal.GaugeBlock;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.GaugeBlockEntity>;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get blockEntityType(): Internal.BlockEntityType<Internal.GaugeBlockEntity>
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): typeof Internal.GaugeBlockEntity
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
        static readonly GAUGE: Internal.GaugeShaper;
    }
    type GaugeBlock_ = GaugeBlock;
    interface PositionalRandomFactory {
        abstract fromHashOf(arg0: string): Internal.RandomSource;
        abstract at(arg0: number, arg1: number, arg2: number): Internal.RandomSource;
        fromHashOf($$0: ResourceLocation_): Internal.RandomSource;
        at($$0: BlockPos_): Internal.RandomSource;
        abstract parityConfigString(arg0: Internal.StringBuilder_): void;
    }
    type PositionalRandomFactory_ = PositionalRandomFactory;
    class StandardBogeyBlock extends Internal.AbstractBogeyBlock<Internal.StandardBogeyBlockEntity> implements Internal.ProperWaterloggedBlock, Internal.IBE<Internal.StandardBogeyBlockEntity>, Internal.SpecialBlockItemRequirement {
        constructor(props: Internal.BlockBehaviour$Properties_, size: Internal.BogeySizes$BogeySize_)
        getConnectorAnchorOffset(): Vec3d;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.StandardBogeyBlockEntity>;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.StandardBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getBlockEntityType(): Internal.BlockEntityType<Internal.StandardBogeyBlockEntity>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.StandardBogeyBlockEntity;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.StandardBogeyBlockEntity>): void;
        getBlockEntityClass(): typeof Internal.StandardBogeyBlockEntity;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get connectorAnchorOffset(): Vec3d
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityType(): Internal.BlockEntityType<Internal.StandardBogeyBlockEntity>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.StandardBogeyBlockEntity
    }
    type StandardBogeyBlock_ = StandardBogeyBlock;
    class RenderType$CompositeRenderType extends Internal.RenderType implements Internal.ETFRenderLayerWithTexture, Internal.AccessorCompositeRenderType, Internal.BlendingStateHolder {
        etf$getId(): Internal.Optional<any>;
        hex$state(): Internal.RenderType$CompositeState;
        static port_lib$create(string: string, vertexFormat: Internal.VertexFormat_, mode: Internal.VertexFormat$Mode_, i: number, bl: boolean, bl2: boolean, compositeState: Internal.RenderType$CompositeState_): Internal.RenderType$CompositeRenderType;
        static catnip$create(string: string, vertexFormat: Internal.VertexFormat_, mode: Internal.VertexFormat$Mode_, i: number, bl: boolean, bl2: boolean, compositeState: Internal.RenderType$CompositeState_): Internal.RenderType$CompositeRenderType;
        static getTranslucentTransparency(): Internal.RenderStateShard$TransparencyStateShard;
        state(): Internal.RenderType$CompositeState;
        static hex$create(string: string, vertexFormat: Internal.VertexFormat_, mode: Internal.VertexFormat$Mode_, bufSize: number, hasCrumbling: boolean, sortOnUpload: boolean, compositeState: Internal.RenderType$CompositeState_): Internal.RenderType$CompositeRenderType;
        static getGLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getCRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        static getNO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard;
        get translucentTransparency(): Internal.RenderStateShard$TransparencyStateShard
        get GLINT_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get CRUMBLING_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        get NO_TRANSPARENCY(): Internal.RenderStateShard$TransparencyStateShard
        readonly state: Internal.RenderType$CompositeState;
    }
    type RenderType$CompositeRenderType_ = RenderType$CompositeRenderType;
    class AppendLoot implements Internal.RuleBlockEntityModifier {
        constructor($$0: ResourceLocation_)
        getType(): Internal.RuleBlockEntityModifierType<any>;
        apply($$0: Internal.RandomSource_, $$1: Internal.CompoundTag_): Internal.CompoundTag;
        get type(): Internal.RuleBlockEntityModifierType<any>
        static readonly CODEC: Internal.Codec<Internal.AppendLoot>;
    }
    type AppendLoot_ = AppendLoot;
    class LinearPosTest extends Internal.PosRuleTest {
        constructor($$0: number, $$1: number, $$2: number, $$3: number)
        static readonly CODEC: Internal.Codec<Internal.LinearPosTest>;
    }
    type LinearPosTest_ = LinearPosTest;
    abstract class Type$TypeError {
        constructor(arg0: string)
    }
    type Type$TypeError_ = Type$TypeError;
    abstract class Reader implements Internal.Closeable, Internal.Readable {
        static nullReader(): Internal.Reader;
        transferTo(arg0: Internal.Writer_): number;
        read(arg0: Internal.CharBuffer_): number;
        read(): number;
        markSupported(): boolean;
        mark(arg0: number): void;
        abstract close(): void;
        abstract read(arg0: string[], arg1: number, arg2: number): number;
        ready(): boolean;
        read(arg0: string[]): number;
        reset(): void;
        skip(arg0: number): number;
    }
    type Reader_ = Reader;
    class ObsidianPipeBlock extends Internal.BooleanDirectionsPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
    }
    type ObsidianPipeBlock_ = ObsidianPipeBlock;
    class ModifiableDaggerItem extends Internal.ModifiableSwordItem {
        constructor(properties: Internal.Item$Properties_, toolDefinition: Internal.ToolDefinition_, tab: Internal.ResourceKey_<Internal.CreativeModeTab>)
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static getDisplayStack(item: Internal.Item_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLocalizedName(): net.minecraft.network.chat.Component;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getStatInformation(tool: Internal.IToolStackView_, player: Internal.Player_, tooltips: Internal.List_<net.minecraft.network.chat.Component>, key: Internal.TooltipKey_, tooltipFlag: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        /**
         * @deprecated
        */
        getStatInformation(tool: Internal.IToolStackView_, player: Internal.Player_, tooltips: Internal.List_<net.minecraft.network.chat.Component>, key: slimeknights.tconstruct.library.utils.TooltipKey_, tooltipFlag: Internal.TooltipFlag_): Internal.List<net.minecraft.network.chat.Component>;
        setAttackDamage(attackDamage: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        static setRarity(volatileData: Internal.ModDataNBT_, rarity: Internal.Rarity_): void;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        get localizedName(): net.minecraft.network.chat.Component
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ModifiableDaggerItem_ = ModifiableDaggerItem;
    interface CreativeModeTab$Output {
        acceptAll($$0: Internal.Collection_<Internal.ItemStack>, $$1: Internal.CreativeModeTab$TabVisibility_): void;
        accept($$0: Internal.ItemStack_): void;
        abstract accept(arg0: Internal.ItemStack_, arg1: Internal.CreativeModeTab$TabVisibility_): void;
        accept($$0: Internal.ItemLike_, $$1: Internal.CreativeModeTab$TabVisibility_): void;
        acceptAll($$0: Internal.Collection_<Internal.ItemStack>): void;
        accept($$0: Internal.ItemLike_): void;
        (arg0: Internal.ItemStack, arg1: Internal.CreativeModeTab$TabVisibility): void;
    }
    type CreativeModeTab$Output_ = CreativeModeTab$Output;
    interface PrivateKey extends Internal.Key, Internal.Destroyable {
        abstract getAlgorithm(): string;
        abstract getFormat(): string;
        destroy(): void;
        isDestroyed(): boolean;
        abstract getEncoded(): number[];
        get algorithm(): string
        get format(): string
        get destroyed(): boolean
        get encoded(): number[]
        /**
         * @deprecated
        */
        readonly serialVersionUID: 6034044314589513430;
    }
    type PrivateKey_ = PrivateKey;
    class BloodFluid$Source extends Internal.BloodFluid {
        constructor()
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type BloodFluid$Source_ = BloodFluid$Source;
    class EntityRendererProvider$Context {
        constructor($$0: Internal.EntityRenderDispatcher_, $$1: Internal.ItemRenderer_, $$2: Internal.BlockRenderDispatcher_, $$3: Internal.ItemInHandRenderer_, $$4: Internal.ResourceManager_, $$5: Internal.EntityModelSet_, $$6: net.minecraft.client.gui.Font_)
        getFont(): net.minecraft.client.gui.Font;
        getItemInHandRenderer(): Internal.ItemInHandRenderer;
        getItemRenderer(): Internal.ItemRenderer;
        getModelSet(): Internal.EntityModelSet;
        getModelManager(): Internal.ModelManager;
        getEntityRenderDispatcher(): Internal.EntityRenderDispatcher;
        getBlockRenderDispatcher(): Internal.BlockRenderDispatcher;
        getResourceManager(): Internal.ResourceManager;
        bakeLayer($$0: Internal.ModelLayerLocation_): Internal.ModelPart;
        get font(): net.minecraft.client.gui.Font
        get itemInHandRenderer(): Internal.ItemInHandRenderer
        get itemRenderer(): Internal.ItemRenderer
        get modelSet(): Internal.EntityModelSet
        get modelManager(): Internal.ModelManager
        get entityRenderDispatcher(): Internal.EntityRenderDispatcher
        get blockRenderDispatcher(): Internal.BlockRenderDispatcher
        get resourceManager(): Internal.ResourceManager
    }
    type EntityRendererProvider$Context_ = EntityRendererProvider$Context;
    class WeatherMachineBlock extends Internal.BaseEntityBlock {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(world: Internal.Level_, state: Internal.BlockState_, type: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        method_9515(builder: Internal.StateDefinition$Builder_<Internal.Block, Internal.BlockState>): void;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly TEMP: Internal.IntegerProperty;
        static readonly TANK: Internal.IntegerProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type WeatherMachineBlock_ = WeatherMachineBlock;
    class DepositFilterLogic extends Internal.FilterLogic {
        constructor(upgrade: Internal.ItemStack_, saveHandler: Internal.Consumer_<Internal.ItemStack>, filterSlotCount: number)
        setInventory(inventory: Internal.Storage_<Internal.ItemVariant>): void;
        setDepositFilterType(depositFilterType: Internal.DepositFilterType_): void;
        getDepositFilterType(): Internal.DepositFilterType;
        set inventory(inventory: Internal.Storage_<Internal.ItemVariant>)
        set depositFilterType(depositFilterType: Internal.DepositFilterType_)
        get depositFilterType(): Internal.DepositFilterType
    }
    type DepositFilterLogic_ = DepositFilterLogic;
    class FloatArgumentInfo$Template implements Internal.ArgumentTypeInfo$Template<Internal.FloatArgumentType> {
        instantiate(arg0: Internal.CommandBuildContext_): Internal.ArgumentType<any>;
        type(): Internal.ArgumentTypeInfo<Internal.FloatArgumentType, any>;
        instantiate($$0: Internal.CommandBuildContext_): Internal.FloatArgumentType;
    }
    type FloatArgumentInfo$Template_ = FloatArgumentInfo$Template;
    class BlockBehaviour$OffsetType extends Internal.Enum<Internal.BlockBehaviour$OffsetType> {
        static valueOf($$0: string): Internal.BlockBehaviour$OffsetType;
        static values(): Internal.BlockBehaviour$OffsetType[];
        static readonly NONE: Internal.BlockBehaviour$OffsetType;
        static readonly XZ: Internal.BlockBehaviour$OffsetType;
        static readonly XYZ: Internal.BlockBehaviour$OffsetType;
    }
    type BlockBehaviour$OffsetType_ = BlockBehaviour$OffsetType | "xyz" | "none" | "xz";
    class WiredModemFullBlock extends Internal.Block implements Internal.EntityBlock {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly PERIPHERAL_ON: Internal.BooleanProperty;
        static readonly MODEM_ON: Internal.BooleanProperty;
    }
    type WiredModemFullBlock_ = WiredModemFullBlock;
    class ChestBlockEntity extends Internal.RandomizableContainerBlockEntity implements Internal.InventoryChangeTracker, Internal.LidBlockEntity, Internal.InventoryChangeEmitter, Internal.LithiumInventory {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        stopListenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        static tryClear($$0: any): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getOpenNess($$0: number): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        getSlots(): number;
        setChanged(): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        static lidAnimateTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.ChestBlockEntity_): void;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setInventoryLithium(arg0: Internal.NonNullList_<any>): void;
        invalidateCaps(): void;
        kjs$self(): net.minecraft.world.Container;
        getInventoryLithium(): Internal.NonNullList<any>;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        asComponentProvider(): Internal.ComponentProvider;
        handler$elh001$lithium$setInventoryStackListReplacement(list: Internal.NonNullList_<any>, ci: Internal.CallbackInfo_): void;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        fabric_onTransfer(slot: number, transaction: Internal.TransactionContext_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        emitCallbackReplaced(): void;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isEmpty(): boolean;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        shouldCloseCurrentScreen(): boolean;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        listenForContentChangesOnce(stackList: Internal.LithiumStackList_, inventoryChangeListener: Internal.InventoryChangeListener_): void;
        getHeight(): number;
        countNonEmpty(): number;
        listenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        asContainer(): net.minecraft.world.Container;
        getAllItems(): Internal.List<Internal.ItemStack>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        generateLootLithium(): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        recheckOpen(): void;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        static swapContents($$0: Internal.ChestBlockEntity_, $$1: Internal.ChestBlockEntity_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        static getOpenCount($$0: Internal.BlockGetter_, $$1: BlockPos_): number;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get slots(): number
        set inventoryLithium(arg0: Internal.NonNullList_<any>)
        get inventoryLithium(): Internal.NonNullList<any>
        get width(): number
        get maxStackSize(): number
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        items: Internal.NonNullList<Internal.ItemStack>;
    }
    type ChestBlockEntity_ = ChestBlockEntity;
    class ClientboundBlockChangedAckPacket extends Internal.Record implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: number)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        sequence(): number;
        get skippable(): boolean
    }
    type ClientboundBlockChangedAckPacket_ = ClientboundBlockChangedAckPacket;
    interface SequenceLayout extends Internal.MemoryLayout {
        sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): this;
        abstract toString(): string;
        withName(arg0: string): Internal.MemoryLayout;
        sequenceLayout(arg0: Internal.MemoryLayout_): this;
        abstract elementCount(): number;
        abstract name(): Internal.Optional<string>;
        abstract elementLayout(): Internal.MemoryLayout;
        byteOffset(...arg0: any_[]): number;
        abstract byteSize(): number;
        abstract flatten(): this;
        structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        abstract withoutName(): Internal.MemoryLayout;
        abstract hashCode(): number;
        abstract withByteAlignment(arg0: number): this;
        abstract reshape(...arg0: number[]): this;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        abstract byteAlignment(): number;
        abstract withElementCount(arg0: number): this;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
        abstract equals(arg0: any): boolean;
    }
    type SequenceLayout_ = SequenceLayout;
    abstract class FileSystemProvider {
        abstract readAttributes<A extends Internal.BasicFileAttributes>(arg0: Internal.Path_, arg1: A, ...arg2: any_[]): A;
        abstract move(arg0: Internal.Path_, arg1: Internal.Path_, ...arg2: any_[]): void;
        static installedProviders(): Internal.List<Internal.FileSystemProvider>;
        abstract "delete"(arg0: Internal.Path_): void;
        createLink(arg0: Internal.Path_, arg1: Internal.Path_): void;
        abstract getFileStore(arg0: Internal.Path_): Internal.FileStore;
        newFileChannel(arg0: Internal.Path_, arg1: Internal.Set_<Internal.OpenOption>, ...arg2: any_<any>[]): Internal.FileChannel;
        abstract getFileAttributeView<V extends Internal.FileAttributeView>(arg0: Internal.Path_, arg1: V, ...arg2: any_[]): V;
        abstract createDirectory(arg0: Internal.Path_, ...arg1: any_<any>[]): void;
        createSymbolicLink(arg0: Internal.Path_, arg1: Internal.Path_, ...arg2: any_<any>[]): void;
        abstract getScheme(): string;
        newAsynchronousFileChannel(arg0: Internal.Path_, arg1: Internal.Set_<Internal.OpenOption>, arg2: Internal.ExecutorService_, ...arg3: any_<any>[]): Internal.AsynchronousFileChannel;
        abstract newFileSystem(arg0: Internal.URI_, arg1: Internal.Map_<string, any>): Internal.FileSystem;
        abstract newDirectoryStream(arg0: Internal.Path_, arg1: Internal.DirectoryStream$Filter_<Internal.Path>): Internal.DirectoryStream<Internal.Path>;
        abstract isSameFile(arg0: Internal.Path_, arg1: Internal.Path_): boolean;
        abstract readAttributes(arg0: Internal.Path_, arg1: string, ...arg2: any_[]): Internal.Map<string, any>;
        exists(arg0: Internal.Path_, ...arg1: any_[]): boolean;
        readSymbolicLink(arg0: Internal.Path_): Internal.Path;
        abstract isHidden(arg0: Internal.Path_): boolean;
        newFileSystem(arg0: Internal.Path_, arg1: Internal.Map_<string, any>): Internal.FileSystem;
        newOutputStream(arg0: Internal.Path_, ...arg1: Internal.OpenOption_[]): Internal.OutputStream;
        abstract checkAccess(arg0: Internal.Path_, ...arg1: any_[]): void;
        abstract setAttribute(arg0: Internal.Path_, arg1: string, arg2: any, ...arg3: any_[]): void;
        abstract copy(arg0: Internal.Path_, arg1: Internal.Path_, ...arg2: any_[]): void;
        abstract newByteChannel(arg0: Internal.Path_, arg1: Internal.Set_<Internal.OpenOption>, ...arg2: any_<any>[]): Internal.SeekableByteChannel;
        deleteIfExists(arg0: Internal.Path_): boolean;
        newInputStream(arg0: Internal.Path_, ...arg1: Internal.OpenOption_[]): Internal.InputStream;
        abstract getFileSystem(arg0: Internal.URI_): Internal.FileSystem;
        readAttributesIfExists<A extends Internal.BasicFileAttributes>(arg0: Internal.Path_, arg1: A, ...arg2: any_[]): A;
        abstract getPath(arg0: Internal.URI_): Internal.Path;
        get scheme(): string
    }
    type FileSystemProvider_ = FileSystemProvider;
    interface AddressLayout extends Internal.ValueLayout {
        sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract arrayElementVarHandle(...arg0: number[]): Internal.VarHandle;
        sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract withoutTargetLayout(): this;
        abstract withTargetLayout(arg0: Internal.MemoryLayout_): this;
        byteOffset(...arg0: any_[]): number;
        withName(arg0: string): Internal.ValueLayout;
        withoutName(): Internal.ValueLayout;
        abstract order(): Internal.ByteOrder;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
        abstract withByteAlignment(arg0: number): this;
        abstract toString(): string;
        abstract name(): Internal.Optional<string>;
        abstract withOrder(arg0: Internal.ByteOrder_): this;
        abstract byteSize(): number;
        abstract targetLayout(): Internal.Optional<Internal.MemoryLayout>;
        structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        abstract hashCode(): number;
        abstract byteAlignment(): number;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        abstract carrier(): typeof any;
        abstract equals(arg0: any): boolean;
    }
    type AddressLayout_ = AddressLayout;
    class EventHandlerContainer {
        constructor(extraId: any, handler: Internal.IEventHandler_, source: string, line: number)
        add(extraId: any, handler: Internal.IEventHandler_, source: string, line: number): void;
        handle(event: Internal.EventJS_, exh: Internal.EventExceptionHandler_): Internal.EventResult;
        static isEmpty(array: Internal.EventHandlerContainer_[]): boolean;
        readonly source: string;
        readonly handler: Internal.IEventHandler;
        readonly extraId: any;
        readonly line: number;
    }
    type EventHandlerContainer_ = EventHandlerContainer;
    class VisibilityData {
        constructor()
        hasCustomVisibility(part: string): boolean;
        copyFrom(visibilityData: Internal.VisibilityData_): void;
        isVisible(part: string, fallback: boolean): boolean;
        setVisibilityState(partName: string, type: boolean): void;
    }
    type VisibilityData_ = VisibilityData;
    class StorageComponentItem extends Internal.AEBaseItem implements Internal.IStorageComponent {
        constructor(properties: Internal.Item$Properties_, storageInKb: number)
        isStorageComponent(is: Internal.ItemStack_): boolean;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getBytes(is: Internal.ItemStack_): number;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type StorageComponentItem_ = StorageComponentItem;
    class VoidUpgradeWrapper extends Internal.UpgradeWrapperBase<Internal.VoidUpgradeWrapper, Internal.VoidUpgradeItem> implements Internal.IFilteredUpgrade, Internal.ISlotLimitUpgrade, Internal.IOverflowResponseUpgrade, Internal.ISlotChangeResponseUpgrade, Internal.IInsertResponseUpgrade, Internal.ITickableUpgrade {
        constructor(storageWrapper: Internal.IStorageWrapper_, upgrade: Internal.ItemStack_, upgradeSaveHandler: Internal.Consumer_<Internal.ItemStack>)
        tick(entity: Internal.Entity_, world: Internal.Level_, pos: BlockPos_): void;
        onSlotChange(inventoryHandler: Internal.SlottedStackStorage_, slot: number): void;
        getFilterLogic(): Internal.FilterLogic;
        isVoidAnythingEnabled(): boolean;
        getSlotLimit(): number;
        setShouldVoidOverflowDefaultOrLoadFromNbt(shouldVoidOverflowDefault: boolean): void;
        canBeDisabled(): boolean;
        worksInGui(): boolean;
        onAfterInsert(inventoryHandler: Internal.IItemHandlerSimpleInserter_, slot: number, ctx: Internal.TransactionContext_): void;
        onOverflow(stack: Internal.ItemStack_): Internal.ItemStack;
        hideSettingsTab(): boolean;
        onBeforeInsert(inventoryHandler: Internal.IItemHandlerSimpleInserter_, slot: number, resource: Internal.ItemVariant_, maxAmount: number, ctx: Internal.TransactionContext_): number;
        stackMatchesFilter(stack: Internal.ItemStack_): boolean;
        stackMatchesFilterStack(stack: Internal.ItemStack_, filterStack: Internal.ItemStack_): boolean;
        setShouldVoidOverflow(shouldVoidOverflow: boolean): void;
        setShouldWorkdInGUI(shouldWorkdInGUI: boolean): void;
        shouldVoidOverflow(): boolean;
        shouldWorkInGUI(): boolean;
        onAdded(): void;
        onBeforeRemoved(): void;
        get filterLogic(): Internal.FilterLogic
        get voidAnythingEnabled(): boolean
        get slotLimit(): number
        set shouldVoidOverflowDefaultOrLoadFromNbt(shouldVoidOverflowDefault: boolean)
        set shouldVoidOverflow(shouldVoidOverflow: boolean)
        set shouldWorkdInGUI(shouldWorkdInGUI: boolean)
    }
    type VoidUpgradeWrapper_ = VoidUpgradeWrapper;
    interface Transaction extends Internal.TransactionContext, Internal.AutoCloseable {
        abstract abort(): void;
        getLifecycle(): Internal.Transaction$Lifecycle;
        abstract addCloseCallback(arg0: Internal.TransactionContext$CloseCallback_): void;
        /**
         * @deprecated
        */
        getCurrentUnsafe(): Internal.TransactionContext;
        openNested(maybeParent: Internal.TransactionContext_): this;
        abstract openNested(): this;
        isOpen(): boolean;
        abstract nestingDepth(): number;
        abstract addOuterCloseCallback(arg0: Internal.TransactionContext$OuterCloseCallback_): void;
        abstract close(): void;
        openOuter(): this;
        abstract commit(): void;
        abstract getOpenTransaction(arg0: number): this;
        get lifecycle(): Internal.Transaction$Lifecycle
        /**
         * @deprecated
        */
        get currentUnsafe(): Internal.TransactionContext
        get open(): boolean
    }
    type Transaction_ = Transaction;
    class RefinedRadianceItem extends Internal.NoGravMagicalDohickyItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type RefinedRadianceItem_ = RefinedRadianceItem;
    interface FabricPacket {
        abstract write(arg0: Internal.FriendlyByteBuf_): void;
        abstract getType(): Internal.PacketType<any>;
        get type(): Internal.PacketType<any>
    }
    type FabricPacket_ = FabricPacket;
    class OceanMonumentStructure extends Internal.Structure {
        constructor($$0: Internal.Structure$StructureSettings_)
        static regeneratePiecesAfterLoad($$0: Internal.ChunkPos_, $$1: number, $$2: Internal.PiecesContainer_): Internal.PiecesContainer;
        method_38676($$0: Internal.Structure$GenerationContext_): Internal.Optional<Internal.Structure$GenerationStub>;
        static readonly CODEC: Internal.Codec<Internal.OceanMonumentStructure>;
    }
    type OceanMonumentStructure_ = OceanMonumentStructure;
    class ItemModSword extends Internal.SwordItem implements Internal.DragonSteelOverrides<Internal.ItemModSword> {
        constructor(toolmaterial: Internal.Tier_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isDragonSteelLightning(tier: Internal.Tier_): boolean;
        isDragonSteelFire(tier: Internal.Tier_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isDragonSteel(tier: Internal.Tier_): boolean;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        appendHoverText(tier: Internal.Tier_, stack: Internal.ItemStack_, worldIn: Internal.Level_, tooltip: Internal.List_<net.minecraft.network.chat.Component>, flagIn: Internal.TooltipFlag_): void;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        isDragonSteelIce(tier: Internal.Tier_): boolean;
        emi(amount: number): Internal.EmiStack;
        getAttackDamage(item: Internal.ItemModSword_): number;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        /**
         * @deprecated
        */
        bakeDragonsteel(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        hurtEnemy(item: Internal.ItemModSword_, stack: Internal.ItemStack_, target: Internal.LivingEntity_, attacker: Internal.LivingEntity_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemModSword_ = ItemModSword;
    class EntropyRecipeSerializer implements Internal.RecipeSerializer<Internal.EntropyRecipe> {
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        fromJson(recipeId: ResourceLocation_, json: Internal.JsonObject_): Internal.EntropyRecipe;
        fromNetwork(recipeId: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): Internal.EntropyRecipe;
        toNetwork(buffer: Internal.FriendlyByteBuf_, recipe: Internal.EntropyRecipe_): void;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        toJson(recipe: Internal.EntropyRecipe_, json: Internal.JsonObject_): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        static readonly INSTANCE: Internal.EntropyRecipeSerializer;
    }
    type EntropyRecipeSerializer_ = EntropyRecipeSerializer;
    class Sound implements Internal.Weighted<Internal.Sound> {
        constructor($$0: string, $$1: Internal.SampledFloat_, $$2: Internal.SampledFloat_, $$3: number, $$4: Internal.Sound$Type_, $$5: boolean, $$6: boolean, $$7: number)
        getType(): Internal.Sound$Type;
        getVolume(): Internal.SampledFloat;
        getPitch(): Internal.SampledFloat;
        getLocation(): ResourceLocation;
        getSound(arg0: Internal.RandomSource_): any;
        getPath(): ResourceLocation;
        getAttenuationDistance(): number;
        getSound($$0: Internal.RandomSource_): this;
        getWeight(): number;
        preloadIfRequired($$0: Internal.SoundEngine_): void;
        shouldStream(): boolean;
        shouldPreload(): boolean;
        get type(): Internal.Sound$Type
        get volume(): Internal.SampledFloat
        get pitch(): Internal.SampledFloat
        get location(): ResourceLocation
        get path(): ResourceLocation
        get attenuationDistance(): number
        get weight(): number
        static readonly SOUND_LISTER: Internal.FileToIdConverter;
    }
    type Sound_ = Sound;
    class ServerboundClientCommandPacket$Action extends Internal.Enum<Internal.ServerboundClientCommandPacket$Action> {
        static valueOf($$0: string): Internal.ServerboundClientCommandPacket$Action;
        static values(): Internal.ServerboundClientCommandPacket$Action[];
        static readonly REQUEST_STATS: Internal.ServerboundClientCommandPacket$Action;
        static readonly PERFORM_RESPAWN: Internal.ServerboundClientCommandPacket$Action;
    }
    type ServerboundClientCommandPacket$Action_ = "request_stats" | "perform_respawn" | ServerboundClientCommandPacket$Action;
    interface NativeImageAccessor {
        abstract getField_4988(): number;
        get field_4988(): number
        (): number;
    }
    type NativeImageAccessor_ = NativeImageAccessor;
    interface ValueLayout$OfBoolean extends Internal.ValueLayout {
        sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract toString(): string;
        withName(arg0: string): Internal.MemoryLayout;
        abstract arrayElementVarHandle(...arg0: number[]): Internal.VarHandle;
        sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        abstract name(): Internal.Optional<string>;
        byteOffset(...arg0: any_[]): number;
        abstract byteSize(): number;
        withByteAlignment(arg0: number): Internal.MemoryLayout;
        withOrder(arg0: Internal.ByteOrder_): Internal.ValueLayout;
        structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        withoutName(): Internal.MemoryLayout;
        abstract hashCode(): number;
        abstract order(): Internal.ByteOrder;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        abstract byteAlignment(): number;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        abstract carrier(): typeof any;
        unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
        abstract equals(arg0: any): boolean;
    }
    type ValueLayout$OfBoolean_ = ValueLayout$OfBoolean;
    class HatShapedRecipe implements Internal.CraftingRecipe {
        constructor(model: number, recipe: Internal.ShapedRecipe_)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        matches(inventory: Internal.CraftingContainer_, world: Internal.Level_): boolean;
        getSchema(): Internal.RecipeSchema;
        getModel(): number;
        category(): Internal.CraftingBookCategory;
        getSerializer(): Internal.RecipeSerializer<any>;
        assemble(inventory: net.minecraft.world.Container_, registryManager: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(inventory: net.minecraft.world.Container_, world: Internal.Level_): boolean;
        craft(inventory: Internal.CraftingContainer_, registries: Internal.RegistryAccess_): Internal.ItemStack;
        getRemainder(inventory: Internal.CraftingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getMod(): string;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        getResultItem(registries: Internal.RegistryAccess_): Internal.ItemStack;
        getRemainingItems(inventory: net.minecraft.world.Container_): Internal.NonNullList<any>;
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        static access$getIDENTIFIER$cp(): ResourceLocation;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        getRecipe(): Internal.ShapedRecipe;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get model(): number
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get recipe(): Internal.ShapedRecipe
        static readonly Companion: Internal.HatShapedRecipe$Companion;
    }
    type HatShapedRecipe_ = HatShapedRecipe;
    interface ZipConstants {
        readonly EXTHDR: number;
        readonly LOCCRC: number;
        readonly LOCHOW: number;
        readonly CENSIZ: number;
        readonly EXTLEN: number;
        readonly ENDSIZ: number;
        readonly CENVEM: number;
        readonly CENHDR: number;
        readonly LOCNAM: number;
        readonly EXTSIZ: number;
        readonly LOCVER: number;
        readonly ENDCOM: number;
        readonly CENSIG: number;
        readonly CENLEN: number;
        readonly CENCOM: number;
        readonly ENDOFF: number;
        readonly LOCSIG: number;
        readonly LOCHDR: number;
        readonly ENDSUB: number;
        readonly EXTCRC: number;
        readonly CENHOW: number;
        readonly LOCLEN: number;
        readonly LOCSIZ: number;
        readonly CENCRC: number;
        readonly CENVER: number;
        readonly CENTIM: number;
        readonly CENNAM: number;
        readonly CENATT: number;
        readonly CENDSK: number;
        readonly LOCEXT: number;
        readonly LOCFLG: number;
        readonly LOCTIM: number;
        readonly CENFLG: number;
        readonly CENEXT: number;
        readonly ENDSIG: number;
        readonly EXTSIG: number;
        readonly ENDHDR: number;
        readonly CENATX: number;
        readonly CENOFF: number;
        readonly ENDTOT: number;
    }
    type ZipConstants_ = ZipConstants;
    class CarrotBlock extends Internal.CropBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type CarrotBlock_ = CarrotBlock;
    interface IExternalPowerSink extends Internal.IAEPowerStorage {
        abstract getAEMaxPower(): number;
        abstract getExternalPowerDemand(arg0: Internal.PowerUnits_, arg1: number): number;
        abstract getPowerFlow(): Internal.AccessRestriction;
        getPriority(): number;
        abstract injectExternalPower(arg0: Internal.PowerUnits_, arg1: number, arg2: Internal.Actionable_): number;
        abstract injectAEPower(arg0: number, arg1: Internal.Actionable_): number;
        abstract isAEPublicPowerStorage(): boolean;
        abstract getAECurrentPower(): number;
        abstract extractAEPower(arg0: number, arg1: Internal.Actionable_, arg2: Internal.PowerMultiplier_): number;
        get AEMaxPower(): number
        get powerFlow(): Internal.AccessRestriction
        get priority(): number
        get AEPublicPowerStorage(): boolean
        get AECurrentPower(): number
    }
    type IExternalPowerSink_ = IExternalPowerSink;
    class PatternIota extends Internal.Iota {
        constructor(pattern: Internal.HexPattern_)
        static deserialize(tag: Internal.Tag_): Internal.PatternIota;
        toleratesOther(that: Internal.Iota_): boolean;
        getPattern(): Internal.HexPattern;
        static display(pat: Internal.HexPattern_): net.minecraft.network.chat.Component;
        static displayNonInline(pat: Internal.HexPattern_): net.minecraft.network.chat.Component;
        get pattern(): Internal.HexPattern
        static TYPE: Internal.PatternIota$1;
    }
    type PatternIota_ = PatternIota;
    interface IPartBuilderContainer extends Internal.ISingleStackContainer {
        stopOpen($$0: Internal.Player_): void;
        count(ingredient: Internal.Ingredient_): number;
        tryClear($$0: any): void;
        count(): number;
        setTransferCooldown(currentTime: number): void;
        countItem(itemIn: Internal.Item_): number;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        isEmpty(): boolean;
        clear(ingredient: Internal.Ingredient_): void;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        find(): number;
        hasAnyOf(set: Internal.Set_<Internal.Item>): boolean;
        /**
         * @deprecated
        */
        removeItem(index: number, count: number): Internal.ItemStack;
        abstract getStack(): Internal.ItemStack;
        getSlots(): number;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        setChanged(): void;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        abstract getPatternStack(): Internal.ItemStack;
        /**
         * @deprecated
        */
        getContainerSize(): number;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        /**
         * @deprecated
        */
        setItem(index: number, stack: Internal.ItemStack_): void;
        getHeight(): number;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        countNonEmpty(): number;
        asContainer(): net.minecraft.world.Container;
        kjs$self(): net.minecraft.world.Container;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        getAllItems(): Internal.List<Internal.ItemStack>;
        /**
         * @deprecated
        */
        removeItemNoUpdate(index: number): Internal.ItemStack;
        stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        /**
         * @deprecated
        */
        stillValid(player: Internal.Player_): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        isMutable(): boolean;
        clear(): void;
        /**
         * @deprecated
        */
        getItem(index: number): Internal.ItemStack;
        find(ingredient: Internal.Ingredient_): number;
        abstract getMaterial(): Internal.IMaterialValue;
        /**
         * @deprecated
        */
        clearContent(): void;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get stack(): Internal.ItemStack
        get slots(): number
        get patternStack(): Internal.ItemStack
        /**
         * @deprecated
        */
        get containerSize(): number
        get height(): number
        get width(): number
        get maxStackSize(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        get material(): Internal.IMaterialValue
    }
    type IPartBuilderContainer_ = IPartBuilderContainer;
    interface Byte2ReferenceFunction <V> extends Internal.IntFunction<V>, it.unimi.dsi.fastutil.Function<number, V> {
        composeLong(arg0: Internal.Long2ByteFunction_): Internal.Long2ReferenceFunction<V>;
        andThenDouble(arg0: Internal.Reference2DoubleFunction_<V>): Internal.Byte2DoubleFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        put(arg0: number, arg1: V): V;
        composeObject<T>(arg0: Internal.Object2ByteFunction_<T>): Internal.Object2ReferenceFunction<T, V>;
        composeChar(arg0: Internal.Char2ByteFunction_): Internal.Char2ReferenceFunction<V>;
        andThenInt(arg0: Internal.Reference2IntFunction_<V>): Internal.Byte2IntFunction;
        andThenLong(arg0: Internal.Reference2LongFunction_<V>): Internal.Byte2LongFunction;
        andThenReference<T>(arg0: Internal.Reference2ReferenceFunction_<V, T>): Internal.Byte2ReferenceFunction<T>;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        composeFloat(arg0: Internal.Float2ByteFunction_): Internal.Float2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeReference<T>(arg0: Internal.Reference2ByteFunction_<T>): Internal.Reference2ReferenceFunction<T, V>;
        andThenObject<T>(arg0: Internal.Reference2ObjectFunction_<V, T>): Internal.Byte2ObjectFunction<T>;
        composeShort(arg0: Internal.Short2ByteFunction_): Internal.Short2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        abstract get(arg0: number): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        apply(arg0: number): V;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        containsKey(arg0: number): boolean;
        remove(arg0: number): V;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        composeByte(arg0: Internal.Byte2ByteFunction_): this;
        andThenShort(arg0: Internal.Reference2ShortFunction_<V>): Internal.Byte2ShortFunction;
        apply(arg0: number): V;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        andThenChar(arg0: Internal.Reference2CharFunction_<V>): Internal.Byte2CharFunction;
        andThenFloat(arg0: Internal.Reference2FloatFunction_<V>): Internal.Byte2FloatFunction;
        andThenByte(arg0: Internal.Reference2ByteFunction_<V>): Internal.Byte2ByteFunction;
        size(): number;
        getOrDefault(arg0: number, arg1: V): V;
        composeInt(arg0: Internal.Int2ByteFunction_): Internal.Int2ReferenceFunction<V>;
        clear(): void;
        defaultReturnValue(): V;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        composeDouble(arg0: Internal.Double2ByteFunction_): Internal.Double2ReferenceFunction<V>;
        (arg0: number): V;
    }
    type Byte2ReferenceFunction_<V> = Byte2ReferenceFunction<V>;
    class TagKeyComponent <T> extends Internal.Record implements Internal.RecipeComponent<Internal.TagKey<T>> {
        constructor(registry: Internal.ResourceKey_<Internal.Registry<T>>, registryType: typeof any)
        readFromJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<Internal.TagKey<T>>, json: Internal.JsonObject_): void;
        replaceOutput(recipe: Internal.RecipeJS_, original: Internal.TagKey_<T>, match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): Internal.TagKey<T>;
        write(arg0: Internal.RecipeJS_, arg1: any): Internal.JsonElement;
        registryType(): typeof any;
        or<O>(other: Internal.RecipeComponent_<O>): Internal.OrRecipeComponent<Internal.TagKey<T>, O>;
        asPatternKey(): Internal.RecipeComponent<Internal.TinyMap<string, Internal.TagKey<T>>>;
        asMap<K>(key: Internal.RecipeComponent_<K>): Internal.RecipeComponent<Internal.TinyMap<K, Internal.TagKey<T>>>;
        isInput(recipe: Internal.RecipeJS_, value: Internal.TagKey_<T>, match: Internal.ReplacementMatch_): boolean;
        write(recipe: Internal.RecipeJS_, value: Internal.TagKey_<T>): Internal.JsonPrimitive;
        role(): Internal.ComponentRole;
        componentClass(): typeof any;
        asArray(): Internal.ArrayRecipeComponent<Internal.TagKey<T>>;
        /**
         * Returns a new RecipeComponent that applies the mappingFrom function after the component writes to json, before that json is saved
        */
        mapOut(mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<Internal.TagKey<T>>;
        orSelf(): Internal.RecipeComponent<Internal.TagKey<T>>;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read
        */
        mapIn(mappingTo: Internal.UnaryOperator_<any>): Internal.MappingRecipeComponent<Internal.TagKey<T>>;
        registry(): Internal.ResourceKey<Internal.Registry<T>>;
        key(name: string): Internal.RecipeKey<Internal.TagKey<T>>;
        constructorDescription(ctx: Internal.DescriptionContext_): Internal.TypeDescJS;
        componentType(): string;
        asArrayOrSelf(): Internal.ArrayRecipeComponent<Internal.TagKey<T>>;
        checkValueHasChanged(oldValue: Internal.TagKey_<T>, newValue: Internal.TagKey_<T>): boolean;
        isOutput(recipe: Internal.RecipeJS_, value: Internal.TagKey_<T>, match: Internal.ReplacementMatch_): boolean;
        static builder(): Internal.RecipeComponentBuilder;
        readFromMap(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<Internal.TagKey<T>>, map: Internal.Map_<any, any>): void;
        writeToJson(recipe: Internal.RecipeJS_, cv: Internal.RecipeComponentValue_<Internal.TagKey<T>>, json: Internal.JsonObject_): void;
        and<O>(other: Internal.RecipeComponent_<O>): Internal.AndRecipeComponent<Internal.TagKey<T>, O>;
        hasPriority(recipe: Internal.RecipeJS_, from: any): boolean;
        checkEmpty(key: Internal.RecipeKey_<Internal.TagKey<T>>, value: Internal.TagKey_<T>): string;
        /**
         * Returns a new RecipeComponent that applies the mappingTo function to the input before it is passed to this component to be read, and the mappingFrom function after the component writes to json, before that json is saved
        */
        map(mappingTo: Internal.UnaryOperator_<any>, mappingFrom: Internal.UnaryOperator_<Internal.JsonElement>): Internal.MappingRecipeComponent<Internal.TagKey<T>>;
        /**
         * Returns a new RecipeComponent that maps the keys in a JsonObject according to the provided map, both before the json gets passed to the component and after the component returns a written json object.
         * The mappings should be provided in the format `{recipe: "component"}` where recipe is the key as in the recipe, and component is the key as how the RecipeComponent expects it.
         * Any keys not included in the provided map will be ignored, and any keys in the provided map that are not in either the input object or output object will be ignored.
         * Note that if the input or output is not a JsonObject (ie its an ItemStack, or it is a JsonPrimitive) then that will pass through this without being modified.
         * If you wish to handle those situations use the actual map function
        */
        simpleMap(mappings: any): Internal.SimpleMappingRecipeComponent<Internal.TagKey<T>>;
        static builder(...key: Internal.RecipeKey_<any>[]): Internal.RecipeComponentBuilder;
        read(arg0: Internal.RecipeJS_, arg1: any): any;
        replaceInput(recipe: Internal.RecipeJS_, original: Internal.TagKey_<T>, match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): Internal.TagKey<T>;
        static readonly ENTITY_TYPE: Internal.RecipeComponent<Internal.TagKey<Internal.EntityType<any>>>;
        static readonly BIOME: Internal.RecipeComponent<Internal.TagKey<Internal.Biome>>;
        static readonly DYNAMIC: Internal.DynamicRecipeComponent;
        static readonly FLUID: Internal.RecipeComponent<Internal.TagKey<Internal.Fluid>>;
        static readonly BLOCK: Internal.RecipeComponent<Internal.TagKey<Internal.Block>>;
        static readonly ITEM: Internal.RecipeComponent<Internal.TagKey<Internal.Item>>;
    }
    type TagKeyComponent_<T> = TagKeyComponent<T>;
    class MoltenTinFluid$Flowing extends Internal.MoltenTinFluid {
        constructor(properties: Internal.ModFlowingFluid$Properties_, block: Internal.Supplier_<Internal.LiquidBlock>)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type MoltenTinFluid$Flowing_ = MoltenTinFluid$Flowing;
    interface SpecialBlockEntityItemRequirement {
        abstract getRequiredItems(arg0: Internal.BlockState_): Internal.ItemRequirement;
        (arg0: Internal.BlockState): Internal.ItemRequirement_;
    }
    type SpecialBlockEntityItemRequirement_ = SpecialBlockEntityItemRequirement;
    class Bounds extends Internal.Record {
        constructor(x: number, y: number, width: number, height: number)
        empty(): boolean;
        overlap(another: Internal.Bounds_): this;
        bottom(): number;
        contains(x: number, y: number): boolean;
        y(): number;
        x(): number;
        top(): number;
        right(): number;
        width(): number;
        height(): number;
        left(): number;
        static readonly EMPTY: Internal.Bounds;
    }
    type Bounds_ = Bounds;
    class PotatoRecoveryEnchantment extends Internal.Enchantment implements Internal.CustomEnchantingTableBehaviorEnchantment {
        constructor(rarity: Internal.Enchantment$Rarity_, category: Internal.EnchantmentCategory_, slots: Internal.EquipmentSlot_[])
        canApplyAtEnchantingTable(stack: Internal.ItemStack_): boolean;
    }
    type PotatoRecoveryEnchantment_ = PotatoRecoveryEnchantment;
    class TrackBlockEntity extends Internal.SmartBlockEntity implements Internal.TransformableBlockEntity, Internal.IHasTrackCasing, Internal.IMergeableBE, Internal.RenderDataBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getConnections(): Internal.Map<BlockPos, Internal.BezierConnection>;
        manageFakeTracksAlong(bc: Internal.BezierConnection_, remove: boolean): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        validateConnections(): void;
        addConnection(connection: Internal.BezierConnection_): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        isTilted(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        static isAlternate(world: Internal.Level_, pos: BlockPos_): boolean;
        static setTrackCasing(world: Internal.Level_, pos: BlockPos_, trackCasing: Internal.SlabBlock_): void;
        onLoad(): void;
        bind(boundDimension: Internal.ResourceKey_<Internal.Level>, boundLocation: BlockPos_): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        removeConnection(target: BlockPos_): void;
        accept(other: Internal.BlockEntity_): void;
        isAlternate(): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        static setAlternateModel(world: Internal.Level_, pos: BlockPos_, useAlternateModel: boolean): boolean;
        static getTrackCasing(world: Internal.Level_, pos: BlockPos_): Internal.SlabBlock;
        removeInboundConnections(dropAndDiscard: boolean): void;
        getTrackCasing(): Internal.SlabBlock;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setAlternate(alternate: boolean): void;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        transform(be: Internal.BlockEntity_, transform: Internal.StructureTransform_): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        hasInteractableConnections(): boolean;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderData(): number;
        setTrackCasing(trackCasing: Internal.SlabBlock_): void;
        get connections(): Internal.Map<BlockPos, Internal.BezierConnection>
        get tilted(): boolean
        get alternate(): boolean
        get trackCasing(): Internal.SlabBlock
        set alternate(alternate: boolean)
        get infiniteBoundingBox(): Internal.AABB
        get renderData(): number
        set trackCasing(trackCasing: Internal.SlabBlock_)
        boundLocation: net.createmod.catnip.data.Pair<Internal.ResourceKey<Internal.Level>, BlockPos>;
        tilt: Internal.TrackBlockEntityTilt;
    }
    type TrackBlockEntity_ = TrackBlockEntity;
    class GameConfig$FolderData {
        constructor($$0: Internal.File_, $$1: Internal.File_, $$2: Internal.File_, $$3: string)
        getExternalAssetSource(): Internal.Path;
        get externalAssetSource(): Internal.Path
        readonly gameDirectory: Internal.File;
        readonly assetDirectory: Internal.File;
        readonly assetIndex: string;
        readonly resourcePackDirectory: Internal.File;
    }
    type GameConfig$FolderData_ = GameConfig$FolderData;
    class AudioFormat$Encoding {
        constructor(arg0: string)
        static readonly PCM_SIGNED: Internal.AudioFormat$Encoding;
        static readonly ULAW: Internal.AudioFormat$Encoding;
        static readonly PCM_UNSIGNED: Internal.AudioFormat$Encoding;
        static readonly PCM_FLOAT: Internal.AudioFormat$Encoding;
        static readonly ALAW: Internal.AudioFormat$Encoding;
    }
    type AudioFormat$Encoding_ = AudioFormat$Encoding;
    interface LevelKJS extends Internal.WithAttachedData<Internal.Level>, Internal.ScriptTypeHolder {
        getDisplayName(): net.minecraft.network.chat.Component;
        getDimension(): ResourceLocation;
        getName(): net.minecraft.network.chat.Component;
        self(): Internal.Level;
        runCommandSilent(command: string): number;
        getEntities(): Internal.EntityArrayList;
        spawnParticles(options: Internal.ParticleOptions_, overrideLimiter: boolean, x: number, y: number, z: number, vx: number, vy: number, vz: number, count: number, speed: number): void;
        createEntity(type: Internal.EntityType_<any>): Internal.Entity;
        tell(message: net.minecraft.network.chat.Component_): void;
        createExplosion(x: number, y: number, z: number): Internal.ExplosionJS;
        abstract getData(): Internal.AttachedData<Internal.Level>;
        spawnFireworks(x: number, y: number, z: number, f: Internal.FireworksJS_): void;
        createEntityList(entities: Internal.Collection_<Internal.Entity>): Internal.EntityArrayList;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getPlayers(): Internal.EntityArrayList;
        getEntitiesWithin(aabb: Internal.AABB_): Internal.EntityArrayList;
        getSide(): Internal.ScriptType;
        getBlock(x: number, y: number, z: number): Internal.BlockContainerJS;
        getBlock(pos: BlockPos_): Internal.BlockContainerJS;
        isOverworld(): boolean;
        runCommand(command: string): number;
        getBlock(blockEntity: Internal.BlockEntity_): Internal.BlockContainerJS;
        get displayName(): net.minecraft.network.chat.Component
        get dimension(): ResourceLocation
        get name(): net.minecraft.network.chat.Component
        get entities(): Internal.EntityArrayList
        get data(): Internal.AttachedData<Internal.Level>
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get players(): Internal.EntityArrayList
        get side(): Internal.ScriptType
        get overworld(): boolean
        (): Internal.AttachedData_<Internal.Level>;
    }
    type LevelKJS_ = LevelKJS;
    interface ChronoZonedDateTime <D extends Internal.ChronoLocalDate> extends Internal.Comparable<Internal.ChronoZonedDateTime<any>>, Internal.Temporal {
        isAfter(arg0: Internal.ChronoZonedDateTime_<any>): boolean;
        toLocalTime(): Internal.LocalTime;
        toInstant(): Internal.Instant;
        plus(arg0: number, arg1: Internal.TemporalUnit_): Internal.Temporal;
        compareTo(arg0: any): number;
        abstract toLocalDateTime(): Internal.ChronoLocalDateTime<D>;
        abstract getZone(): Internal.ZoneId;
        "with"(arg0: Internal.TemporalAdjuster_): this;
        getLong(arg0: Internal.TemporalField_): number;
        timeLineOrder(): Internal.Comparator<Internal.ChronoZonedDateTime<any>>;
        "with"(arg0: Internal.TemporalField_, arg1: number): Internal.Temporal;
        minus(arg0: number, arg1: Internal.TemporalUnit_): Internal.Temporal;
        compareTo(arg0: Internal.ChronoZonedDateTime_<any>): number;
        abstract isSupported(arg0: Internal.TemporalField_): boolean;
        format(arg0: Internal.DateTimeFormatter_): string;
        abstract getOffset(): Internal.ZoneOffset;
        getChronology(): Internal.Chronology;
        abstract toString(): string;
        abstract withZoneSameInstant(arg0: Internal.ZoneId_): this;
        isEqual(arg0: Internal.ChronoZonedDateTime_<any>): boolean;
        query<R>(arg0: Internal.TemporalQuery_<R>): R;
        abstract until(arg0: Internal.Temporal_, arg1: Internal.TemporalUnit_): number;
        isSupported(arg0: Internal.TemporalUnit_): boolean;
        isBefore(arg0: Internal.ChronoZonedDateTime_<any>): boolean;
        from(arg0: Internal.TemporalAccessor_): Internal.ChronoZonedDateTime<any>;
        range(arg0: Internal.TemporalField_): Internal.ValueRange;
        plus(arg0: Internal.TemporalAmount_): Internal.Temporal;
        abstract hashCode(): number;
        abstract withEarlierOffsetAtOverlap(): this;
        get(arg0: Internal.TemporalField_): number;
        abstract withZoneSameLocal(arg0: Internal.ZoneId_): this;
        abstract equals(arg0: any): boolean;
        toLocalDate(): D;
        minus(arg0: Internal.TemporalAmount_): Internal.Temporal;
        toEpochSecond(): number;
        abstract withLaterOffsetAtOverlap(): this;
        get zone(): Internal.ZoneId
        get offset(): Internal.ZoneOffset
        get chronology(): Internal.Chronology
    }
    type ChronoZonedDateTime_<D extends Internal.ChronoLocalDate> = ChronoZonedDateTime<D>;
    class BuriedTreasureStructure extends Internal.Structure {
        constructor($$0: Internal.Structure$StructureSettings_)
        method_38676($$0: Internal.Structure$GenerationContext_): Internal.Optional<Internal.Structure$GenerationStub>;
        static readonly CODEC: Internal.Codec<Internal.BuriedTreasureStructure>;
    }
    type BuriedTreasureStructure_ = BuriedTreasureStructure;
    abstract class BiomeSpecialEffects$GrassColorModifier extends Internal.Enum<Internal.BiomeSpecialEffects$GrassColorModifier> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.BiomeSpecialEffects$GrassColorModifier[];
        getName(): string;
        abstract modifyColor(arg0: number, arg1: number, arg2: number): number;
        static valueOf($$0: string): Internal.BiomeSpecialEffects$GrassColorModifier;
        get serializedName(): string
        get name(): string
        static readonly DARK_FOREST: Internal.BiomeSpecialEffects$GrassColorModifier;
        static readonly CODEC: Internal.Codec<Internal.BiomeSpecialEffects$GrassColorModifier>;
        static readonly SWAMP: Internal.BiomeSpecialEffects$GrassColorModifier;
        static readonly NONE: Internal.BiomeSpecialEffects$GrassColorModifier;
    }
    type BiomeSpecialEffects$GrassColorModifier_ = "dark_forest" | BiomeSpecialEffects$GrassColorModifier | "none" | "swamp";
    class TeamPropertyArgument$Info implements Internal.ArgumentTypeInfo<Internal.TeamPropertyArgument, Internal.TeamPropertyArgument$Info$Template> {
        constructor()
        deserializeFromNetwork(arg0: Internal.FriendlyByteBuf_): Internal.ArgumentTypeInfo$Template<any>;
        unpack(arg0: Internal.ArgumentType_<any>): Internal.ArgumentTypeInfo$Template<any>;
        deserializeFromNetwork(friendlyByteBuf: Internal.FriendlyByteBuf_): Internal.TeamPropertyArgument$Info$Template;
        serializeToJson(template: Internal.TeamPropertyArgument$Info$Template_, jsonObject: Internal.JsonObject_): void;
        serializeToNetwork(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.FriendlyByteBuf_): void;
        unpack(argumentType: Internal.TeamPropertyArgument_): Internal.TeamPropertyArgument$Info$Template;
        serializeToNetwork(template: Internal.TeamPropertyArgument$Info$Template_, friendlyByteBuf: Internal.FriendlyByteBuf_): void;
        serializeToJson(arg0: Internal.ArgumentTypeInfo$Template_<any>, arg1: Internal.JsonObject_): void;
    }
    type TeamPropertyArgument$Info_ = TeamPropertyArgument$Info;
    interface PlayerEvents$PlayerXpChange {
        abstract onPlayerXpChange(arg0: Internal.PlayerEvents$XpChange_): void;
        (arg0: Internal.PlayerEvents$XpChange): void;
    }
    type PlayerEvents$PlayerXpChange_ = PlayerEvents$PlayerXpChange;
    class MyceliumSplatterFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        static isAir(level: Internal.LevelSimulatedReader_, pos: BlockPos_): boolean;
    }
    type MyceliumSplatterFeature_ = MyceliumSplatterFeature;
    class EnergizingOrbBlock extends Internal.AbstractBlock<any, Internal.EnergizingOrbBlock> implements Internal.IHud, Internal.SimpleWaterloggedBlock, Internal.IWrenchable {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        search(worldIn: Internal.Level_, pos: BlockPos_): void;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockItem(properties: Internal.Item$Properties_, group: Internal.ResourceKey_<Internal.CreativeModeTab>): Internal.ItemBlock<any, any>;
        renderHud(gui: Internal.GuiGraphics_, state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, result: Internal.BlockHitResult_, te: Internal.BlockEntity_): boolean;
        onWrench(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, hand: Internal.InteractionHand_, side: Internal.Direction_, mode: Internal.WrenchMode_, hit: Vec3d_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type EnergizingOrbBlock_ = EnergizingOrbBlock;
    class XpPumpUpgradeWrapper extends Internal.UpgradeWrapperBase<Internal.XpPumpUpgradeWrapper, Internal.XpPumpUpgradeItem> implements Internal.ITickableUpgrade {
        getLevel(): number;
        getDirection(): Internal.AutomationDirection;
        getLevelsToStore(): number;
        setMendItems(mendItems: boolean): void;
        giveAllExperienceToPlayer(player: Internal.Player_): void;
        tick(entity: Internal.Entity_, world: Internal.Level_, pos: BlockPos_): void;
        giveLevelsToPlayer(player: Internal.Player_): void;
        takeLevelsFromPlayer(player: Internal.Player_): void;
        shouldMendItems(): boolean;
        takeAllExperienceFromPlayer(player: Internal.Player_): void;
        canBeDisabled(): boolean;
        setDirection(direction: Internal.AutomationDirection_): void;
        hideSettingsTab(): boolean;
        setLevel(level: number): void;
        getLevelsToTake(): number;
        setLevelsToStore(levelsToTake: number): void;
        onAdded(): void;
        setLevelsToTake(levelsToGive: number): void;
        onBeforeRemoved(): void;
        get level(): number
        get direction(): Internal.AutomationDirection
        get levelsToStore(): number
        set mendItems(mendItems: boolean)
        set direction(direction: Internal.AutomationDirection_)
        set level(level: number)
        get levelsToTake(): number
        set levelsToStore(levelsToTake: number)
        set levelsToTake(levelsToGive: number)
    }
    type XpPumpUpgradeWrapper_ = XpPumpUpgradeWrapper;
    class HeliumFlamingoItem extends Internal.WearableArtifactItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        hasNonCosmeticEffects(): boolean;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type HeliumFlamingoItem_ = HeliumFlamingoItem;
    abstract class FlyingMob extends Internal.Mob {
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type FlyingMob_ = FlyingMob;
    class InputContext {
        endComposition(): void;
        reconvert(): void;
        setCompositionEnabled(arg0: boolean): void;
        getInputMethodControlObject(): any;
        getLocale(): Internal.Locale;
        isCompositionEnabled(): boolean;
        dispose(): void;
        removeNotify(arg0: Internal.Component_): void;
        static getInstance(): Internal.InputContext;
        dispatchEvent(arg0: Internal.AWTEvent_): void;
        selectInputMethod(arg0: Internal.Locale_): boolean;
        setCharacterSubsets(arg0: any_[]): void;
        set compositionEnabled(arg0: boolean)
        get inputMethodControlObject(): any
        get locale(): Internal.Locale
        get compositionEnabled(): boolean
        get instance(): Internal.InputContext
        set characterSubsets(arg0: any_[])
    }
    type InputContext_ = InputContext;
    class ManureItem extends Internal.BoneMealItem {
        constructor(settings: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ManureItem_ = ManureItem;
    class RecipeWrapperSerializer <T extends Internal.Recipe<any>, R extends Internal.Recipe<any> & Internal.IWrapperRecipe<T>> implements Internal.RecipeSerializer<R> {
        constructor(initialize: Internal.Function_<T, R>, recipeSerializer: Internal.RecipeSerializer_<T>)
        fromJson(recipeId: ResourceLocation_, json: Internal.JsonObject_): R;
        fromNetwork(recipeId: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): R;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        toNetwork(buffer: Internal.FriendlyByteBuf_, recipe: R): void;
    }
    type RecipeWrapperSerializer_<T extends Internal.Recipe<any>, R extends Internal.Recipe<any> & Internal.IWrapperRecipe<T>> = RecipeWrapperSerializer<T, R>;
    interface ScreenKeyboardEvents$AllowKeyRelease {
        abstract allowKeyRelease(arg0: Internal.Screen_, arg1: number, arg2: number, arg3: number): boolean;
        (arg0: Internal.Screen, arg1: number, arg2: number, arg3: number): boolean;
    }
    type ScreenKeyboardEvents$AllowKeyRelease_ = ScreenKeyboardEvents$AllowKeyRelease;
    interface IUpgradeInventory extends Internal.InternalInventory {
        simulateRemove(amount: number, filter: Internal.ItemStack_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        addItems(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        toContainer(): net.minecraft.world.Container;
        getSubInventory(fromSlotInclusive: number, toSlotExclusive: number): Internal.InternalInventory;
        isEmpty(): boolean;
        abstract writeToNBT(arg0: Internal.CompoundTag_, arg1: string): void;
        abstract readFromNBT(arg0: Internal.CompoundTag_, arg1: string): void;
        removeItems(amount: number, filter: Internal.ItemStack_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        sendChangeNotification(slot: number): void;
        toStorage(): Internal.Storage<Internal.ItemVariant>;
        abstract getUpgradableItem(): Internal.ItemLike;
        abstract getStackInSlot(arg0: number): Internal.ItemStack;
        removeSimilarItems(amount: number, filter: Internal.ItemStack_, fuzzyMode: Internal.FuzzyMode_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        abstract getMaxInstalled(arg0: Internal.ItemLike_): number;
        wrapExternal(be: Internal.BlockEntity_, side: Internal.Direction_): Internal.ItemTransfer;
        empty(): Internal.InternalInventory;
        getSlotInv(slotIndex: number): Internal.InternalInventory;
        mayAllowInsertion(): boolean;
        addItems(stack: Internal.ItemStack_): Internal.ItemStack;
        getSlotLimit(slot: number): number;
        iterator(): Internal.Iterator<Internal.ItemStack>;
        isInstalled(upgradeCard: Internal.ItemLike_): boolean;
        simulateSimilarRemove(amount: number, filter: Internal.ItemStack_, fuzzyMode: Internal.FuzzyMode_, destination: Internal.Predicate_<Internal.ItemStack>): Internal.ItemStack;
        spliterator(): Internal.Spliterator<Internal.ItemStack>;
        abstract getInstalledUpgrades(arg0: Internal.ItemLike_): number;
        simulateAdd(stack: Internal.ItemStack_): Internal.ItemStack;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        abstract size(): number;
        forEach(arg0: Internal.Consumer_<Internal.ItemStack>): void;
        abstract setItemDirect(arg0: number, arg1: Internal.ItemStack_): void;
        clear(): void;
        getRedstoneSignal(): number;
        wrapExternal(level: Internal.Level_, pos: BlockPos_, side: Internal.Direction_): Internal.ItemTransfer;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        get empty(): boolean
        get upgradableItem(): Internal.ItemLike
        get redstoneSignal(): number
    }
    type IUpgradeInventory_ = IUpgradeInventory;
    class ItemProviderEntry <T extends Internal.ItemLike> extends Internal.RegistryEntry<T> implements Internal.ItemLike {
        constructor(owner: Internal.AbstractRegistrate_<any>, delegate: Internal.RegistryObject_<T>)
        isIn(stack: Internal.ItemStack_): boolean;
        emi(amount: number): Internal.EmiStack;
        asStack(count: number): Internal.ItemStack;
        static of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): Internal.NonNullSupplier<T>;
        lazy(): Internal.NonNullSupplier<T>;
        asItem(): Internal.Item;
        static of<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        emi(): Internal.EmiStack;
        is(item: Internal.Item_): boolean;
        asStack(): Internal.ItemStack;
        static lazy<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
    }
    type ItemProviderEntry_<T extends Internal.ItemLike> = ItemProviderEntry<T>;
    class SuggestionContext <S> {
        constructor(arg0: Internal.CommandNode_<S>, arg1: number)
        readonly startPos: number;
        readonly parent: Internal.CommandNode<S>;
    }
    type SuggestionContext_<S> = SuggestionContext<S>;
    class MenuBuilder <T extends Internal.AbstractContainerMenu, S extends Internal.Screen & Internal.MenuAccess<T>, P> extends Internal.AbstractBuilder<Internal.MenuType<any>, Internal.MenuType<T>, P, Internal.MenuBuilder<T, S, P>> {
        constructor(owner: Internal.AbstractRegistrate_<any>, parent: P, name: string, callback: Internal.BuilderCallback_, factory: Internal.MenuBuilder$ForgeMenuFactory_<T>, screenFactory: Internal.NonNullSupplier_<Internal.MenuBuilder$ScreenFactory<T, S>>)
        constructor(owner: Internal.AbstractRegistrate_<any>, parent: P, name: string, callback: Internal.BuilderCallback_, factory: Internal.MenuBuilder$MenuFactory_<T>, screenFactory: Internal.NonNullSupplier_<Internal.MenuBuilder$ScreenFactory<T, S>>)
        onRegisterAfter<OR>(dependencyType: Internal.ResourceKey_<Internal.Registry<OR>>, callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<Internal.MenuType<T>>): this;
        getEntry(): Internal.MenuType<T>;
        static of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): Internal.NonNullSupplier<T>;
        static of<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        static lazy<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        lazy(): Internal.NonNullSupplier<Internal.RegistryEntry<T>>;
        addMiscData<D extends Internal.RegistrateProvider>(type: Internal.ProviderType_<D>, cons: com.tterrag.registrate.util.nullness.NonNullConsumer_<D>): this;
        setData<D extends Internal.RegistrateProvider>(type: Internal.ProviderType_<D>, cons: Internal.NonNullBiConsumer_<Internal.DataGenContext<Internal.MenuType<any>, Internal.MenuType<T>>, D>): this;
        onRegister(callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<Internal.MenuType<T>>): this;
        get(): Internal.RegistryEntry<Internal.MenuType<T>>;
        register(): Internal.RegistryEntry<any>;
        transform<R2, T2 extends R2, P2, S2 extends Internal.Builder<R2, T2, P2, S2>>(func: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.MenuBuilder<T, S, P>, S2>): S2;
        build(): P;
        get entry(): Internal.MenuType<T>
    }
    type MenuBuilder_<T extends Internal.AbstractContainerMenu, S extends Internal.Screen & Internal.MenuAccess<T>, P> = MenuBuilder<T, S, P>;
    class RealmsServer$WorldType extends Internal.Enum<Internal.RealmsServer$WorldType> {
        static valueOf($$0: string): Internal.RealmsServer$WorldType;
        static values(): Internal.RealmsServer$WorldType[];
        static readonly ADVENTUREMAP: Internal.RealmsServer$WorldType;
        static readonly NORMAL: Internal.RealmsServer$WorldType;
        static readonly EXPERIENCE: Internal.RealmsServer$WorldType;
        static readonly MINIGAME: Internal.RealmsServer$WorldType;
        static readonly INSPIRATION: Internal.RealmsServer$WorldType;
    }
    type RealmsServer$WorldType_ = "normal" | "adventuremap" | "minigame" | "inspiration" | "experience" | RealmsServer$WorldType;
    class SecondaryPoiSensor extends Internal.Sensor<Internal.Villager> {
        constructor()
    }
    type SecondaryPoiSensor_ = SecondaryPoiSensor;
    class DragonEggBlock extends Internal.FallingBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        onLand($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.BlockState_, $$4: Internal.FallingBlockEntity_): void;
        setRequiresTool(v: boolean): void;
        onBrokenAfterFall($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.FallingBlockEntity_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getFallDamageSource($$0: Internal.Entity_): DamageSource;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type DragonEggBlock_ = DragonEggBlock;
    abstract class PlacementFilter extends Internal.PlacementModifier {
        constructor()
    }
    type PlacementFilter_ = PlacementFilter;
    class DamageEffects extends Internal.Enum<Internal.DamageEffects> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static values(): Internal.DamageEffects[];
        getSerializedName(): string;
        static valueOf($$0: string): Internal.DamageEffects;
        sound(): Internal.SoundEvent;
        get serializedName(): string
        static readonly THORNS: Internal.DamageEffects;
        static readonly CODEC: Internal.Codec<Internal.DamageEffects>;
        static readonly HURT: Internal.DamageEffects;
        static readonly POKING: Internal.DamageEffects;
        static readonly DROWNING: Internal.DamageEffects;
        static readonly FREEZING: Internal.DamageEffects;
        static readonly BURNING: Internal.DamageEffects;
    }
    type DamageEffects_ = "thorns" | "drowning" | "hurt" | DamageEffects | "burning" | "poking" | "freezing";
    class AgriMutation$Builder {
        constructor()
        parents(parent1: ResourceLocation_, parent2: ResourceLocation_): this;
        parent1(parent1: string): this;
        parent2(parent2: string): this;
        child(child: ResourceLocation_): this;
        parents(parent1: string, parent2: string): this;
        parent2(parent2: ResourceLocation_): this;
        parent1(parent1: ResourceLocation_): this;
        build(): Internal.AgriMutation;
        child(child: string): this;
        chance(chance: number): this;
    }
    type AgriMutation$Builder_ = AgriMutation$Builder;
    class OptionalDynamic <T> extends Internal.DynamicLike<T> {
        constructor(arg0: Internal.DynamicOps_<T>, arg1: Internal.DataResult_<Internal.Dynamic<T>>)
        getElementGeneric(arg0: T): Internal.DataResult<T>;
        getGeneric(arg0: T): Internal.DataResult<T>;
        map<U>(arg0: Internal.Function_<Internal.Dynamic<T>, U>): Internal.DataResult<U>;
        get(): Internal.DataResult<Internal.Dynamic<T>>;
        orElseEmptyMap(): Internal.Dynamic<T>;
        result(): Internal.Optional<Internal.Dynamic<T>>;
        asStreamOpt(): Internal.DataResult<Internal.Stream<Internal.Dynamic<T>>>;
        getElement(arg0: string): Internal.DataResult<T>;
        asMapOpt(): Internal.DataResult<Internal.Stream<com.mojang.datafixers.util.Pair<Internal.Dynamic<T>, Internal.Dynamic<T>>>>;
        decode<A>(arg0: Internal.Decoder_<A>): Internal.DataResult<com.mojang.datafixers.util.Pair<A, T>>;
        flatMap<U>(arg0: Internal.Function_<Internal.Dynamic<T>, Internal.DataResult<U>>): Internal.DataResult<U>;
        into<V>(arg0: Internal.Function_<Internal.Dynamic<T>, V>): Internal.DataResult<V>;
        orElseEmptyList(): Internal.Dynamic<T>;
        get(arg0: string): this;
    }
    type OptionalDynamic_<T> = OptionalDynamic<T>;
    class SlidingDoorBlockEntity extends Internal.SmartBlockEntity implements Internal.SlidingDoorMode$IHasDoorMode {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        static isOpen(state: Internal.BlockState_): boolean;
        railways$getSlidingDoorMode(): Internal.SlidingDoorMode;
        get infiniteBoundingBox(): Internal.AABB
    }
    type SlidingDoorBlockEntity_ = SlidingDoorBlockEntity;
    class CardboardBlockItem extends Internal.BlockItem {
        constructor(pBlock: Internal.Block_, pProperties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type CardboardBlockItem_ = CardboardBlockItem;
    class RoundingMode extends Internal.Enum<Internal.RoundingMode> {
        static valueOf(arg0: number): Internal.RoundingMode;
        static valueOf(arg0: string): Internal.RoundingMode;
        static values(): Internal.RoundingMode[];
        static readonly FLOOR: Internal.RoundingMode;
        static readonly HALF_DOWN: Internal.RoundingMode;
        static readonly UNNECESSARY: Internal.RoundingMode;
        static readonly HALF_UP: Internal.RoundingMode;
        static readonly UP: Internal.RoundingMode;
        static readonly CEILING: Internal.RoundingMode;
        static readonly DOWN: Internal.RoundingMode;
        static readonly HALF_EVEN: Internal.RoundingMode;
    }
    type RoundingMode_ = "floor" | "up" | "down" | RoundingMode | "half_down" | "ceiling" | "unnecessary" | "half_up" | "half_even";
    class OperatorUnary extends Internal.OperatorBasic {
        constructor(accepts: Internal.IotaMultiPredicate_, inner: Internal.UnaryOperator_<Internal.Iota>)
        inner: Internal.UnaryOperator<Internal.Iota>;
    }
    type OperatorUnary_ = OperatorUnary;
    interface Shape {
        abstract contains(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        abstract contains(arg0: number, arg1: number): boolean;
        abstract getPathIterator(arg0: Internal.AffineTransform_, arg1: number): Internal.PathIterator;
        abstract getBounds(): Internal.Rectangle;
        abstract intersects(arg0: number, arg1: number, arg2: number, arg3: number): boolean;
        abstract getPathIterator(arg0: Internal.AffineTransform_): Internal.PathIterator;
        abstract intersects(arg0: Internal.Rectangle2D_): boolean;
        abstract getBounds2D(): Internal.Rectangle2D;
        abstract contains(arg0: Internal.Rectangle2D_): boolean;
        abstract contains(arg0: Internal.Point2D_): boolean;
        get bounds(): Internal.Rectangle
        get bounds2D(): Internal.Rectangle2D
    }
    type Shape_ = Shape;
    class GantryShaftBlock$Part extends Internal.Enum<Internal.GantryShaftBlock$Part> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf(name: string): Internal.GantryShaftBlock$Part;
        static values(): Internal.GantryShaftBlock$Part[];
        get serializedName(): string
        static readonly END: Internal.GantryShaftBlock$Part;
        static readonly MIDDLE: Internal.GantryShaftBlock$Part;
        static readonly SINGLE: Internal.GantryShaftBlock$Part;
        static readonly START: Internal.GantryShaftBlock$Part;
    }
    type GantryShaftBlock$Part_ = "start" | "single" | "middle" | "end" | GantryShaftBlock$Part;
}
declare namespace net.p3pp3rf1y.sophisticatedcore.mixin.common.accessor {
    interface SlotAccessor {
        abstract setY(arg0: number): void;
        abstract callOnSwapCraft(arg0: number): void;
        abstract setX(arg0: number): void;
        set y(arg0: number)
        set x(arg0: number)
    }
    type SlotAccessor_ = SlotAccessor;
}
declare namespace net.createmod.catnip.data {
    class Pair <F, S> {
        swap(): net.createmod.catnip.data.Pair<S, F>;
        copy(): this;
        static of<F, S>(first: F, second: S): net.createmod.catnip.data.Pair<F, S>;
        setFirst(first: F): void;
        getSecond(): S;
        setSecond(second: S): void;
        getFirst(): F;
        set first(first: F)
        get second(): S
        set second(second: S)
        get first(): F
    }
    type Pair_<F, S> = Pair<F, S>;
}
